/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.competitions;

import com.google.common.base.Strings;
import com.templeosrs.TempleOSRSConfig;
import com.templeosrs.TempleOSRSPlugin;
import com.templeosrs.ui.competitions.TempleCompetitionOverview;
import com.templeosrs.ui.competitions.TempleCompetitionRankings;
import com.templeosrs.ui.competitions.TempleCompetitionWatchlist;
import com.templeosrs.util.TempleService;
import com.templeosrs.util.comp.TempleCompetition;
import com.templeosrs.util.comp.TempleCompetitionInfo;
import com.templeosrs.util.comp.TempleCompetitionParticipant;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import okhttp3.HttpUrl;

public class TempleCompetitions
extends PluginPanel {
    private static final Pattern isNumeric = Pattern.compile("-?\\d+(\\.\\d+)?");
    public final IconTextField lookup;
    private final Client client;
    private final TempleOSRSPlugin plugin;
    private final TempleOSRSConfig config;
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    private final JPanel fetchLayout;
    private final TempleService service;
    private TempleCompetitionWatchlist watchlist;

    @Inject
    public TempleCompetitions(TempleOSRSConfig config, TempleOSRSPlugin plugin, final Client client, TempleService templeService) {
        this.plugin = plugin;
        this.client = client;
        this.config = config;
        this.service = templeService;
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.fetchLayout = new JPanel();
        this.fetchLayout.setLayout(new BoxLayout(this.fetchLayout, 1));
        this.fetchLayout.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1, ColorScheme.DARK_GRAY_COLOR, ColorScheme.SCROLL_TRACK_COLOR), new EmptyBorder(5, 5, 5, 5)));
        this.fetchLayout.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel searchLayout = new JPanel();
        searchLayout.setLayout(new BoxLayout(searchLayout, 0));
        searchLayout.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.lookup = this.buildTextField();
        searchLayout.add((Component)this.lookup);
        final JLabel actions = new JLabel();
        actions.setBorder(new EmptyBorder(0, 5, 0, 0));
        actions.setIcon(new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"gears.png")));
        actions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (client == null) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                JMenuItem fetchPlayerMenuItem = new JMenuItem();
                fetchPlayerMenuItem.setText("Search");
                fetchPlayerMenuItem.addActionListener(ev -> TempleCompetitions.this.fetchCompetition());
                menu.add(fetchPlayerMenuItem);
                JMenuItem openPlayerPageMenuItem = new JMenuItem();
                openPlayerPageMenuItem.setText("Open TempleOSRS");
                openPlayerPageMenuItem.addActionListener(ev -> TempleCompetitions.this.open());
                menu.add(openPlayerPageMenuItem);
                JMenuItem addItemMenuItem = new JMenuItem();
                addItemMenuItem.setText("Add to Watchlist");
                addItemMenuItem.addActionListener(ev -> TempleCompetitions.this.watchlist.addWatchlistItem(TempleCompetitions.this.lookup.getText()));
                menu.add(addItemMenuItem);
                JMenuItem removeItemMenuItem = new JMenuItem();
                removeItemMenuItem.setText("Remove from Watchlist");
                removeItemMenuItem.addActionListener(ev -> TempleCompetitions.this.watchlist.removeWatchlistItem(TempleCompetitions.this.lookup.getText()));
                menu.add(removeItemMenuItem);
                actions.add(menu);
                menu.show(actions, e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                actions.setIcon(new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"gears_light.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                actions.setIcon(new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"gears.png")));
            }
        });
        searchLayout.add(actions);
        this.fetchLayout.add(searchLayout);
        this.watchlist = new TempleCompetitionWatchlist(config, this);
        this.fetchLayout.add(this.watchlist);
        this.add(this.fetchLayout);
        this.errorPanel.setContent("Competitions", "You have not fetched competition information yet.");
        this.add((Component)this.errorPanel);
        if (config.fetchDefaults() && config.getDefaultComp() != 0) {
            this.lookup.setText(Integer.toString(config.getDefaultComp()));
            this.fetchCompetition();
        }
    }

    private IconTextField buildTextField() {
        final IconTextField lookup = new IconTextField();
        lookup.setIcon(IconTextField.Icon.SEARCH);
        lookup.setEditable(true);
        lookup.setPreferredSize(new Dimension(225, 25));
        lookup.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        lookup.addActionListener(e -> this.fetchCompetition());
        lookup.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TempleCompetitions.this.config.getDefaultComp() != 0 && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    lookup.setText(Integer.toString(TempleCompetitions.this.config.getDefaultComp()));
                    TempleCompetitions.this.fetchCompetition();
                }
            }
        });
        lookup.addClearListener(() -> {
            this.completed();
            this.reset();
        });
        return lookup;
    }

    public void fetchCompetition() {
        String id = this.lookup.getText();
        if (Strings.isNullOrEmpty((String)id)) {
            return;
        }
        if (!isNumeric.matcher(id).matches()) {
            this.error();
            return;
        }
        this.loading();
        this.reset();
        new Thread(() -> {
            try {
                this.service.fetchCompetitionAsync(id).whenCompleteAsync((result, err) -> this.response(id, (TempleCompetition)result, (Throwable)err));
            }
            catch (Exception e) {
                this.error();
            }
        }).start();
    }

    private void response(String id, TempleCompetition result, Throwable e) {
        this.remove((Component)this.errorPanel);
        if (!this.lookup.getText().equals(id)) {
            this.completed();
            return;
        }
        if (Objects.isNull(result) || Objects.nonNull(e) || result.error) {
            this.error();
            return;
        }
        this.rebuild(result);
    }

    private void rebuild(TempleCompetition result) {
        if (this.client == null) {
            return;
        }
        TempleCompetitionInfo info = result.compOverview.data.info;
        List<TempleCompetitionParticipant> participants = result.compOverview.data.participants;
        SwingUtilities.invokeLater(() -> {
            TempleCompetitionRankings rankings = new TempleCompetitionRankings(this.plugin, participants);
            TempleCompetitionOverview compOverview = new TempleCompetitionOverview(info, rankings.i);
            this.add(compOverview);
            this.add(rankings);
        });
        this.completed();
        this.revalidate();
        this.repaint();
    }

    public void rebuildWatchlist() {
        this.watchlist = new TempleCompetitionWatchlist(this.config, this);
        this.fetchLayout.remove(1);
        this.fetchLayout.add(this.watchlist);
        this.fetchLayout.revalidate();
        this.fetchLayout.repaint();
    }

    private void open() {
        String id = this.lookup.getText();
        if (Strings.isNullOrEmpty((String)id)) {
            return;
        }
        if (!isNumeric.matcher(id).matches()) {
            this.error();
            return;
        }
        this.loading();
        HttpUrl url = new HttpUrl.Builder().scheme("https").host("templeosrs.com").addPathSegment("competitions").addPathSegment("standings.php").addQueryParameter("id", id).build();
        SwingUtilities.invokeLater(() -> LinkBrowser.browse((String)url.toString()));
        this.completed();
    }

    private void reset() {
        this.removeAll();
        this.add(this.fetchLayout);
        this.add((Component)this.errorPanel);
        this.repaint();
        this.revalidate();
    }

    private void error() {
        this.lookup.setIcon(IconTextField.Icon.ERROR);
        this.lookup.setEditable(true);
    }

    private void loading() {
        this.lookup.setIcon(IconTextField.Icon.LOADING);
        this.lookup.setEditable(false);
    }

    private void completed() {
        this.lookup.setIcon(IconTextField.Icon.SEARCH);
        this.lookup.setEditable(true);
    }
}

