/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.competitions;

import com.google.common.base.Strings;
import com.templeosrs.TempleOSRSConfig;
import com.templeosrs.ui.competitions.TempleCompetitions;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.LinkedHashSet;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.util.Text;

public class TempleCompetitionWatchlist
extends JPanel {
    public static JComboBox<String> jComboBox;
    private final TempleOSRSConfig config;

    public TempleCompetitionWatchlist(TempleOSRSConfig config, TempleCompetitions panel) {
        this.config = config;
        String[] competitions = new String[Text.fromCSV((String)config.getCompetitionWatchlist()).size()];
        for (int i = 0; i < Text.fromCSV((String)config.getCompetitionWatchlist()).size(); ++i) {
            competitions[i] = (String)Text.fromCSV((String)config.getCompetitionWatchlist()).get(i);
        }
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.setMinimumSize(new Dimension(225, 20));
        this.setBorder(new EmptyBorder(5, 0, 0, 0));
        jComboBox = new JComboBox<String>(competitions);
        jComboBox.addActionListener(e -> {
            panel.lookup.setText((String)jComboBox.getSelectedItem());
            panel.fetchCompetition();
        });
        jComboBox.setSelectedItem(config.getDefaultComp());
        this.add(jComboBox);
    }

    void addWatchlistItem(String competitionId) {
        if (Strings.isNullOrEmpty((String)competitionId)) {
            return;
        }
        LinkedHashSet<String> watchlist = new LinkedHashSet<String>(Text.fromCSV((String)this.config.getCompetitionWatchlist()));
        if (!watchlist.contains(competitionId)) {
            watchlist.add(competitionId);
            this.config.setCompetitionWatchlist(Text.toCSV(watchlist));
        }
    }

    void removeWatchlistItem(String competitionId) {
        if (Strings.isNullOrEmpty((String)competitionId)) {
            return;
        }
        LinkedHashSet watchlist = new LinkedHashSet(Text.fromCSV((String)this.config.getCompetitionWatchlist()));
        if (watchlist.contains(competitionId)) {
            watchlist.remove(competitionId);
            this.config.setCompetitionWatchlist(Text.toCSV(watchlist));
        }
    }
}

