/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.competitions;

import com.templeosrs.TempleOSRSPlugin;
import com.templeosrs.util.comp.TempleCompetitionParticipant;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.QuantityFormatter;

public class TempleCompetitionRow
extends JPanel {
    TempleCompetitionRow(TempleOSRSPlugin plugin, TempleCompetitionParticipant player, int i, Color color) {
        this.setLayout(new BorderLayout());
        final JPanel row = new JPanel();
        row.setLayout(new GridLayout());
        row.setBackground(color);
        row.setPreferredSize(new Dimension(225, 25));
        row.setToolTipText("<html>Start: <span style='color:#32a0fa'>" + QuantityFormatter.quantityToStackSize((long)player.startXp.longValue()) + "</span><br>End: <span style='color:#32a0fa'>" + QuantityFormatter.quantityToStackSize((long)player.endXp.longValue()) + "</span></html>");
        JLabel name = new JLabel(i + ". " + player.username);
        name.setBorder(new EmptyBorder(0, 5, 0, 0));
        name.setFont(FontManager.getRunescapeSmallFont());
        row.add(name);
        JLabel xp = new JLabel(QuantityFormatter.quantityToStackSize((long)player.xpGained.longValue()));
        xp.setBorder(new EmptyBorder(0, 5, 0, 0));
        xp.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        xp.setFont(FontManager.getRunescapeSmallFont());
        row.add(xp);
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem lookupPlayer = new JMenuItem();
        lookupPlayer.setText("<html>Lookup <span style='color:#6ee16e'>" + player.username + "</span></html>");
        lookupPlayer.addActionListener(e -> plugin.fetchUser(player.username));
        menu.add(lookupPlayer);
        row.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                menu.show(row, e.getX(), e.getY());
            }
        });
        this.add(row);
    }
}

