/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.competitions;

import com.templeosrs.TempleOSRSPlugin;
import com.templeosrs.ui.competitions.TempleCompetitionRow;
import com.templeosrs.util.comp.TempleCompetitionParticipant;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class TempleCompetitionRankings
extends JPanel {
    private static final Color[] COLORS = new Color[]{ColorScheme.DARK_GRAY_HOVER_COLOR, ColorScheme.DARKER_GRAY_COLOR};
    public int i = 0;

    TempleCompetitionRankings(TempleOSRSPlugin plugin, List<TempleCompetitionParticipant> participantList) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, -2, 0, -2));
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BorderLayout());
        layoutPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel compRankings = new JPanel();
        compRankings.setLayout(new GridLayout(0, 1));
        JPanel compHeader = new JPanel();
        compHeader.setLayout(new BoxLayout(this, 0));
        compHeader.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        compHeader.setPreferredSize(new Dimension(225, 20));
        compHeader.setLayout(new GridLayout(0, 2));
        JLabel label = new JLabel("Name");
        label.setBorder(new EmptyBorder(0, 5, 0, 0));
        label.setFont(FontManager.getRunescapeSmallFont());
        compHeader.add(label);
        JLabel gain = new JLabel("Total");
        gain.setBorder(new EmptyBorder(0, 5, 0, 0));
        gain.setFont(FontManager.getRunescapeSmallFont());
        compHeader.add(gain);
        compRankings.add(compHeader);
        for (TempleCompetitionParticipant player : participantList) {
            if (!Objects.nonNull(player.xpGained) || !(player.xpGained > 0.0)) continue;
            TempleCompetitionRow row = new TempleCompetitionRow(plugin, player, this.i + 1, COLORS[this.i % 2]);
            compRankings.add(row);
            ++this.i;
        }
        layoutPanel.add((Component)compRankings, "South");
        TitledBorder custom = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1, ColorScheme.DARK_GRAY_COLOR, ColorScheme.SCROLL_TRACK_COLOR), "Competition Rankings");
        custom.setTitleColor(ColorScheme.GRAND_EXCHANGE_LIMIT);
        custom.setTitleJustification(2);
        custom.setTitleFont(FontManager.getRunescapeSmallFont());
        if (this.i > 15) {
            this.setPreferredSize(new Dimension(225, 425));
            JScrollPane scroll = new JScrollPane(layoutPanel);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.setHorizontalScrollBarPolicy(31);
            scroll.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            scroll.setBorder(custom);
            this.add(scroll);
        } else {
            layoutPanel.setBorder(custom);
            this.add(layoutPanel);
        }
    }
}

