/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.competitions;

import com.templeosrs.TempleOSRSPlugin;
import com.templeosrs.util.TempleHiscoreSkill;
import com.templeosrs.util.comp.TempleCompetitionInfo;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;

public class TempleCompetitionOverview
extends JPanel {
    TempleCompetitionOverview(TempleCompetitionInfo info, int memberCount) {
        ImageIcon icon;
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BoxLayout(layoutPanel, 1));
        layoutPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1, ColorScheme.DARK_GRAY_COLOR, ColorScheme.SCROLL_TRACK_COLOR), new EmptyBorder(5, 5, 5, 5)));
        layoutPanel.setOpaque(false);
        String name = info.name;
        JLabel compName = new JLabel(name);
        compName.setFont(FontManager.getRunescapeBoldFont());
        compName.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        compName.setAlignmentX(0.5f);
        compName.setToolTipText(name);
        layoutPanel.add(compName);
        JPanel fieldLayout = new JPanel();
        fieldLayout.setLayout(new FlowLayout());
        fieldLayout.setOpaque(false);
        JLabel field = new JLabel("Participants:");
        field.setFont(FontManager.getRunescapeSmallFont());
        field.setAlignmentX(0.5f);
        fieldLayout.add(field);
        JLabel count = new JLabel(String.valueOf(memberCount));
        count.setFont(FontManager.getRunescapeSmallFont());
        fieldLayout.add(count);
        JPanel statusLayout = new JPanel();
        statusLayout.setLayout(new FlowLayout());
        statusLayout.setOpaque(false);
        JLabel statusLabel = new JLabel("Status:");
        statusLabel.setFont(FontManager.getRunescapeSmallFont());
        statusLabel.setAlignmentX(0.5f);
        statusLayout.add(statusLabel);
        String statusText = info.statusText;
        JLabel status = new JLabel(statusText);
        status.setFont(FontManager.getRunescapeSmallFont());
        if (statusText.equals("Finished")) {
            status.setForeground(ColorScheme.PROGRESS_COMPLETE_COLOR);
        } else if (statusText.equals("In progress")) {
            status.setForeground(ColorScheme.PROGRESS_INPROGRESS_COLOR);
        } else {
            status.setForeground(ColorScheme.PROGRESS_ERROR_COLOR);
        }
        statusLayout.add(status);
        layoutPanel.add(statusLayout);
        layoutPanel.add(fieldLayout);
        TempleHiscoreSkill skill = TempleHiscoreSkill.values()[info.skillIndex];
        String skillName = skill.getName();
        String formattedName = skillName.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        String iconPath = skill.getType().equals((Object)HiscoreSkillType.SKILL) ? "skills/skill_icon_" + formattedName + ".png" : "bosses/game_icon_" + formattedName + ".png";
        JLabel iconLabel = new JLabel();
        try {
            icon = new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)iconPath));
        }
        catch (Exception e) {
            icon = new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"bosses/game_icon_null.png"));
        }
        iconLabel.setIcon(icon);
        iconLabel.setAlignmentX(0.5f);
        iconLabel.setToolTipText(info.skill);
        layoutPanel.add(iconLabel);
        this.add(layoutPanel);
    }
}

