/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.clans;

import com.google.common.base.Strings;
import com.templeosrs.TempleOSRSConfig;
import com.templeosrs.TempleOSRSPlugin;
import com.templeosrs.ui.clans.TempleClanAchievements;
import com.templeosrs.ui.clans.TempleClanCurrentTop;
import com.templeosrs.ui.clans.TempleClanCurrentTopList;
import com.templeosrs.ui.clans.TempleClanMembers;
import com.templeosrs.ui.clans.TempleClanMembersList;
import com.templeosrs.ui.clans.TempleClanOverview;
import com.templeosrs.util.TempleService;
import com.templeosrs.util.clan.TempleClan;
import com.templeosrs.util.clan.TempleClanAchievement;
import com.templeosrs.util.clan.TempleClanOverviewInfo;
import com.templeosrs.util.sync.TempleSync;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.api.Client;
import net.runelite.api.clan.ClanMember;
import net.runelite.api.clan.ClanRank;
import net.runelite.api.clan.ClanSettings;
import net.runelite.api.clan.ClanTitle;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.IconTextField;
import net.runelite.client.ui.components.PluginErrorPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.Text;
import okhttp3.HttpUrl;

public class TempleClans
extends PluginPanel {
    private static final Pattern isNumeric = Pattern.compile("-?\\d+(\\.\\d+)?");
    public final IconTextField lookup;
    private final Client client;
    private final ClientThread thread;
    private final TempleOSRSPlugin plugin;
    private final TempleOSRSConfig config;
    private final PluginErrorPanel errorPanel = new PluginErrorPanel();
    private final JPanel fetchLayout;
    public TempleClanAchievements clanAchievements;
    public TempleClanMembers clanMembers;
    public TempleClanCurrentTop clanCurrentTop;
    public TempleService service;

    @Inject
    public TempleClans(TempleOSRSConfig config, TempleOSRSPlugin plugin, final Client client, ClientThread thread, TempleService templeService) {
        this.plugin = plugin;
        this.client = client;
        this.thread = thread;
        this.config = config;
        this.service = templeService;
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.fetchLayout = new JPanel();
        this.fetchLayout.setLayout(new BoxLayout(this.fetchLayout, 1));
        this.fetchLayout.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1, ColorScheme.DARK_GRAY_COLOR, ColorScheme.SCROLL_TRACK_COLOR), new EmptyBorder(5, 5, 5, 5)));
        this.fetchLayout.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel searchLayout = new JPanel();
        searchLayout.setLayout(new BoxLayout(searchLayout, 0));
        searchLayout.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.lookup = this.buildTextField();
        searchLayout.add((Component)this.lookup);
        final JLabel actions = new JLabel();
        actions.setBorder(new EmptyBorder(0, 5, 0, 0));
        actions.setIcon(new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"gears.png")));
        actions.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (client == null) {
                    return;
                }
                JPopupMenu menu = new JPopupMenu();
                JMenuItem fetchPlayerMenuItem = new JMenuItem();
                fetchPlayerMenuItem.setText("Search");
                fetchPlayerMenuItem.addActionListener(ev -> TempleClans.this.fetchClan());
                menu.add(fetchPlayerMenuItem);
                JMenuItem openPlayerPageMenuItem = new JMenuItem();
                openPlayerPageMenuItem.setText("Open TempleOSRS");
                openPlayerPageMenuItem.addActionListener(ev -> TempleClans.this.open());
                menu.add(openPlayerPageMenuItem);
                JMenuItem syncClanMembersMenuItem = new JMenuItem();
                syncClanMembersMenuItem.setText("Sync Clan Members");
                syncClanMembersMenuItem.addActionListener(ev -> TempleClans.this.verify());
                menu.add(syncClanMembersMenuItem);
                actions.add(menu);
                menu.show(actions, e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                actions.setIcon(new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"gears_light.png")));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                actions.setIcon(new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"gears.png")));
            }
        });
        searchLayout.add(actions);
        this.fetchLayout.add(searchLayout);
        this.add(this.fetchLayout);
        this.errorPanel.setContent("Clans", "You have not fetched clan information yet.");
        this.add((Component)this.errorPanel);
        if (config.fetchDefaults() && config.getDefaultClan() != 0) {
            this.lookup.setText(Integer.toString(config.getDefaultClan()));
            this.fetchClan();
        }
    }

    private IconTextField buildTextField() {
        final IconTextField lookup = new IconTextField();
        lookup.setIcon(IconTextField.Icon.SEARCH);
        lookup.setEditable(true);
        lookup.setPreferredSize(new Dimension(225, 25));
        lookup.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        lookup.addActionListener(e -> this.fetchClan());
        lookup.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (TempleClans.this.config.getDefaultClan() != 0 && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    lookup.setText(Integer.toString(TempleClans.this.config.getDefaultClan()));
                    TempleClans.this.fetchClan();
                }
                if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu = new JPopupMenu();
                    JMenuItem fetchPlayerMenuItem = new JMenuItem();
                    fetchPlayerMenuItem.setText("Search");
                    fetchPlayerMenuItem.addActionListener(ev -> TempleClans.this.fetchClan());
                    menu.add(fetchPlayerMenuItem);
                    JMenuItem openPlayerPageMenuItem = new JMenuItem();
                    openPlayerPageMenuItem.setText("Open TempleOSRS");
                    openPlayerPageMenuItem.addActionListener(ev -> TempleClans.this.open());
                    menu.add(openPlayerPageMenuItem);
                    lookup.add((Component)menu);
                    JMenuItem syncClanMembersMenuItem = new JMenuItem();
                    syncClanMembersMenuItem.setText("Sync Clan Members");
                    syncClanMembersMenuItem.addActionListener(ev -> TempleClans.this.verify());
                    menu.add(syncClanMembersMenuItem);
                    lookup.add((Component)menu);
                    menu.show((Component)lookup, e.getX(), e.getY());
                }
            }
        });
        lookup.addClearListener(() -> {
            this.completed();
            this.reset();
        });
        return lookup;
    }

    public void fetchClan() {
        String id = this.lookup.getText();
        if (Strings.isNullOrEmpty((String)id)) {
            return;
        }
        if (!isNumeric.matcher(id).matches()) {
            this.error();
            return;
        }
        this.loading();
        this.reset();
        new Thread(() -> {
            try {
                this.service.fetchClanAsync(id, this.config.getCurrentTopRange().getRange()).whenCompleteAsync((result, err) -> this.response(id, (TempleClan)result, (Throwable)err));
            }
            catch (Exception e) {
                this.error();
            }
        }).start();
    }

    private void reload(String id) {
        this.loading();
        this.reset();
        try {
            this.service.fetchClanAsync(id, this.config.getCurrentTopRange().getRange()).whenCompleteAsync((result, err) -> this.response(id, (TempleClan)result, (Throwable)err));
        }
        catch (Exception e) {
            this.error();
        }
    }

    private void rebuild(TempleClan result) {
        if (this.client == null) {
            return;
        }
        String[] leaders = result.clanOverview.data.leaders;
        String[] members = result.clanOverview.data.members;
        TempleClanOverviewInfo info = result.clanOverview.data.info;
        List<TempleClanAchievement> clanActivity = result.clanAchievements.data;
        SwingUtilities.invokeLater(() -> {
            this.add(new TempleClanOverview(info));
            this.clanAchievements = new TempleClanAchievements(this.plugin, clanActivity);
            if (this.config.displayClanAchievements()) {
                this.add(this.clanAchievements);
            }
            TempleClanCurrentTopList clanCurrentTopEhp = new TempleClanCurrentTopList(this.plugin, result.clanCurrentTopEhp.list, this.config.getCurrentTopRange());
            TempleClanCurrentTopList clanCurrentTopEhb = new TempleClanCurrentTopList(this.plugin, result.clanCurrentTopEhb.list, this.config.getCurrentTopRange());
            this.clanCurrentTop = new TempleClanCurrentTop(clanCurrentTopEhp, clanCurrentTopEhb);
            if (this.config.displayClanCurrentTop()) {
                this.add((Component)((Object)this.clanCurrentTop));
            }
            this.clanMembers = new TempleClanMembers(new TempleClanMembersList(this.plugin, "Leaders", leaders), new TempleClanMembersList(this.plugin, "Members", members));
            if (this.config.displayClanMembers()) {
                this.add((Component)((Object)this.clanMembers));
            }
        });
        this.completed();
        this.revalidate();
        this.repaint();
    }

    private void open() {
        String id = this.lookup.getText();
        if (Strings.isNullOrEmpty((String)id)) {
            return;
        }
        if (!isNumeric.matcher(id).matches()) {
            this.error();
            return;
        }
        this.loading();
        HttpUrl url = new HttpUrl.Builder().scheme("https").host("templeosrs.com").addPathSegment("groups").addPathSegment("overview.php").addQueryParameter("id", id).build();
        SwingUtilities.invokeLater(() -> LinkBrowser.browse((String)url.toString()));
        this.completed();
    }

    private void verify() {
        if (this.client == null) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.config.clanKey())) {
            return;
        }
        ClanSettings localClan = this.client.getClanSettings();
        if (localClan == null) {
            return;
        }
        int confirmation = JOptionPane.showOptionDialog((Component)this.lookup, "This will sync the fetched clan's TempleOSRS members-list to all members in the current account's clan (Requires Key).", "Are you sure?", 0, 2, null, new String[]{"Yes", "No"}, "No");
        if (confirmation != 0) {
            return;
        }
        this.filter(localClan);
    }

    private void verify(List<String> filteredList) {
        this.loading();
        String id = this.lookup.getText();
        new Thread(() -> {
            try {
                if (this.config.onlyAddMembers()) {
                    this.service.addClanMembersAsync(id, this.config.clanKey(), filteredList).whenCompleteAsync((result, err) -> this.response(id, (TempleSync)result, (Throwable)err));
                } else {
                    this.service.syncClanMembersAsync(id, this.config.clanKey(), filteredList).whenCompleteAsync((result, err) -> this.response(id, (TempleSync)result, (Throwable)err));
                }
            }
            catch (Exception e) {
                this.error();
            }
        }).start();
    }

    private void filter(ClanSettings localClan) {
        ArrayList clanList = new ArrayList();
        List ignoredRanks = Text.fromCSV((String)this.config.getIgnoredRanks());
        this.thread.invoke(() -> {
            for (ClanMember member : localClan.getMembers()) {
                String title;
                ClanRank rank = member.getRank();
                ClanTitle clanTitle = localClan.titleForRank(rank);
                if (clanTitle == null || ignoredRanks.contains(title = clanTitle.getName())) continue;
                clanList.add(this.format(member.getName()));
            }
            this.verify(clanList);
        });
    }

    private void response(String id, TempleSync response, Throwable e) {
        if (Objects.isNull(response) || Objects.nonNull(e) || response.error) {
            this.error();
            return;
        }
        this.reload(id);
    }

    private void response(String id, TempleClan result, Throwable e) {
        this.remove((Component)this.errorPanel);
        if (!this.lookup.getText().equals(id)) {
            this.completed();
            return;
        }
        if (Objects.isNull(result) || Objects.nonNull(e) || result.error) {
            this.error();
            return;
        }
        this.rebuild(result);
    }

    private void reset() {
        this.clanAchievements = null;
        this.clanMembers = null;
        this.removeAll();
        this.add(this.fetchLayout);
        this.add((Component)this.errorPanel);
        this.repaint();
        this.revalidate();
    }

    private void error() {
        this.lookup.setIcon(IconTextField.Icon.ERROR);
        this.lookup.setEditable(true);
    }

    private void loading() {
        this.lookup.setIcon(IconTextField.Icon.LOADING);
        this.lookup.setEditable(false);
    }

    private void completed() {
        this.lookup.setIcon(IconTextField.Icon.SEARCH);
        this.lookup.setEditable(true);
    }

    private String format(String text) {
        return text.replace('\u00a0', ' ');
    }
}

