/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.clans;

import com.templeosrs.TempleOSRSPlugin;
import com.templeosrs.ui.clans.TempleClanCurrentTopRow;
import com.templeosrs.util.CurrentTopRanges;
import com.templeosrs.util.clan.TempleClanCurrentTopPlayer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class TempleClanCurrentTopList
extends JPanel {
    private static final Color[] COLORS = new Color[]{ColorScheme.DARK_GRAY_HOVER_COLOR, ColorScheme.DARKER_GRAY_COLOR};

    TempleClanCurrentTopList(TempleOSRSPlugin plugin, Map<String, TempleClanCurrentTopPlayer> skill, CurrentTopRanges range) {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BorderLayout());
        layoutPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel currentTop = new JPanel();
        currentTop.setLayout(new GridLayout(0, 1));
        ArrayList<TempleClanCurrentTopPlayer> players = new ArrayList<TempleClanCurrentTopPlayer>();
        if (Objects.nonNull(skill)) {
            players.addAll(skill.values());
        }
        for (int i = 0; i < players.size(); ++i) {
            TempleClanCurrentTopPlayer player = (TempleClanCurrentTopPlayer)players.get(i);
            TempleClanCurrentTopRow user = new TempleClanCurrentTopRow(plugin, i + 1, player.player, String.format("%.2f", player.xp), COLORS[i % 2]);
            currentTop.add(user);
        }
        layoutPanel.add((Component)currentTop, "South");
        String title = "Current Top - " + range.getName();
        TitledBorder custom = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1, ColorScheme.DARK_GRAY_COLOR, ColorScheme.SCROLL_TRACK_COLOR), title);
        custom.setTitleColor(ColorScheme.GRAND_EXCHANGE_LIMIT);
        custom.setTitleJustification(2);
        custom.setTitleFont(FontManager.getRunescapeSmallFont());
        if (players.size() > 10) {
            this.setPreferredSize(new Dimension(225, 275));
            JScrollPane scroll = new JScrollPane(layoutPanel);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.setHorizontalScrollBarPolicy(31);
            scroll.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            scroll.setBorder(custom);
            this.add(scroll);
        } else {
            layoutPanel.setBorder(custom);
            this.add(layoutPanel);
        }
    }
}

