/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.clans;

import com.templeosrs.TempleOSRSPlugin;
import com.templeosrs.ui.clans.TempleClanAchievementRow;
import com.templeosrs.util.clan.TempleClanAchievement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;

public class TempleClanAchievements
extends JPanel {
    private static final Color[] COLORS = new Color[]{ColorScheme.DARK_GRAY_HOVER_COLOR, ColorScheme.DARKER_GRAY_COLOR};

    TempleClanAchievements(TempleOSRSPlugin plugin, List<TempleClanAchievement> clanActivityList) {
        if (clanActivityList == null) {
            return;
        }
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BorderLayout());
        layoutPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel clanActivity = new JPanel();
        clanActivity.setLayout(new GridLayout(0, 1));
        for (int i = 0; i < clanActivityList.size(); ++i) {
            TempleClanAchievement skill = clanActivityList.get(i);
            HiscoreSkillType type = skill.type.equals("Skill") ? HiscoreSkillType.SKILL : HiscoreSkillType.BOSS;
            TempleClanAchievementRow row = new TempleClanAchievementRow(plugin, skill.username, skill.skill, type, skill.xp, COLORS[i % 2]);
            clanActivity.add(row);
        }
        layoutPanel.add((Component)clanActivity, "South");
        TitledBorder custom = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1, ColorScheme.DARK_GRAY_COLOR, ColorScheme.SCROLL_TRACK_COLOR), "Recent Activity");
        custom.setTitleColor(ColorScheme.GRAND_EXCHANGE_LIMIT);
        custom.setTitleJustification(2);
        custom.setTitleFont(FontManager.getRunescapeSmallFont());
        if (clanActivityList.size() > 10) {
            this.setPreferredSize(new Dimension(225, 275));
            JScrollPane scroll = new JScrollPane(layoutPanel);
            scroll.setVerticalScrollBarPolicy(22);
            scroll.setHorizontalScrollBarPolicy(31);
            scroll.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            scroll.setBorder(custom);
            this.add(scroll);
        } else {
            layoutPanel.setBorder(custom);
            this.add(layoutPanel);
        }
    }
}

