/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui.clans;

import com.templeosrs.TempleOSRSPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.hiscore.HiscoreSkillType;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.QuantityFormatter;

public class TempleClanAchievementRow
extends JPanel {
    TempleClanAchievementRow(TempleOSRSPlugin plugin, String name, String skill, HiscoreSkillType type, long xp, Color color) {
        ImageIcon icon;
        this.setLayout(new BorderLayout());
        final JPanel row = new JPanel();
        row.setLayout(new GridLayout(1, 3));
        row.setBorder(new EmptyBorder(2, 0, 2, 0));
        row.setPreferredSize(new Dimension(0, 25));
        row.setBackground(color);
        String formattedName = skill.replaceAll("[^A-Za-z0-9]", "").toLowerCase();
        String iconPath = type.equals((Object)HiscoreSkillType.SKILL) ? "skills/skill_icon_" + formattedName + ".png" : "bosses/game_icon_" + formattedName + ".png";
        try {
            icon = new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)iconPath));
        }
        catch (Exception e2) {
            icon = new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"bosses/game_icon_null.png"));
        }
        JLabel usernameLabel = this.createNewJLabel(name);
        row.add(usernameLabel);
        String xpType = QuantityFormatter.quantityToStackSize((long)xp);
        JLabel xpLabel = this.createNewJLabel(xpType);
        xpLabel.setForeground(ColorScheme.GRAND_EXCHANGE_PRICE);
        xpLabel.setHorizontalAlignment(0);
        row.add(xpLabel);
        JLabel iconLabel = new JLabel();
        iconLabel.setBorder(new EmptyBorder(0, 0, 0, 5));
        iconLabel.setIcon(icon);
        iconLabel.setToolTipText(skill);
        iconLabel.setHorizontalAlignment(4);
        row.add(iconLabel);
        this.add(row);
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem lookupPlayer = new JMenuItem();
        lookupPlayer.setText("<html>Lookup <span style='color:#6ee16e'>" + name + "</span></html>");
        lookupPlayer.addActionListener(e -> plugin.fetchUser(name));
        menu.add(lookupPlayer);
        usernameLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                menu.show(row, e.getX(), e.getY());
            }
        });
    }

    JLabel createNewJLabel(String text) {
        JLabel label = new JLabel(text);
        label.setToolTipText(text);
        label.setFont(FontManager.getRunescapeSmallFont());
        label.setBorder(new EmptyBorder(0, 5, 0, 0));
        return label;
    }
}

