/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs.ui;

import com.templeosrs.TempleOSRSPlugin;
import com.templeosrs.ui.clans.TempleClans;
import com.templeosrs.ui.competitions.TempleCompetitions;
import com.templeosrs.ui.ranks.TempleRanks;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.time.Instant;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.RuneLite;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.components.materialtabs.MaterialTab;
import net.runelite.client.ui.components.materialtabs.MaterialTabGroup;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;

public class TempleOSRSPanel
extends PluginPanel {
    public static final String DEFAULT = "--";
    private static final String SCREENSHOTS = RuneLite.SCREENSHOT_DIR + File.separator + "Temple-Snapshots" + File.separator;
    public final TempleRanks ranks;
    public final TempleClans groups;
    public final TempleCompetitions competitions;
    public final MaterialTabGroup tabGroup;
    public final MaterialTab ranksTab;
    public final MaterialTab groupsTab;
    public final MaterialTab competitionsTab;

    @Inject
    public TempleOSRSPanel(TempleRanks ranks, TempleClans groups, TempleCompetitions competitions) {
        this.ranks = ranks;
        this.groups = groups;
        this.competitions = competitions;
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.getScrollPane().setVerticalScrollBarPolicy(22);
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BoxLayout(layoutPanel, 1));
        layoutPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        JPanel display = new JPanel();
        this.tabGroup = new MaterialTabGroup(display);
        this.ranksTab = new MaterialTab("Ranks", this.tabGroup, (JComponent)((Object)ranks));
        this.groupsTab = new MaterialTab("Clans", this.tabGroup, (JComponent)((Object)groups));
        this.competitionsTab = new MaterialTab("Competitions", this.tabGroup, (JComponent)((Object)competitions));
        this.tabGroup.addTab(this.ranksTab);
        this.tabGroup.addTab(this.groupsTab);
        this.tabGroup.addTab(this.competitionsTab);
        this.tabGroup.select(this.ranksTab);
        layoutPanel.add((Component)this.tabGroup);
        layoutPanel.add(display);
        layoutPanel.add(this.buildScreenshots());
        this.add(layoutPanel);
    }

    private JPanel buildScreenshots() {
        JPanel saveLayout = new JPanel(new BorderLayout());
        saveLayout.setBorder(new EmptyBorder(5, 5, 5, 5));
        saveLayout.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem takeScreenshot = new JMenuItem();
        takeScreenshot.setText("Take Screenshot of current view...");
        takeScreenshot.addActionListener(e -> this.screenshot((JPanel)((Object)this)));
        menu.add(takeScreenshot);
        JMenuItem openFolder = new JMenuItem();
        openFolder.setText("Open screenshot folder...");
        openFolder.addActionListener(e -> {
            if (RuneLite.SCREENSHOT_DIR.exists() || RuneLite.SCREENSHOT_DIR.mkdirs()) {
                LinkBrowser.open((String)RuneLite.SCREENSHOT_DIR.getAbsolutePath());
            }
        });
        menu.add(openFolder);
        final JButton screenshotButton = new JButton();
        screenshotButton.setBorder(new EmptyBorder(5, 5, 5, 5));
        screenshotButton.setIcon(new ImageIcon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"save.png")));
        screenshotButton.setBackground(ColorScheme.SCROLL_TRACK_COLOR);
        screenshotButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                menu.show(screenshotButton, e.getX(), e.getY());
            }
        });
        saveLayout.add((Component)screenshotButton, "West");
        return saveLayout;
    }

    private void screenshot(JPanel panel) {
        String timestamp = String.valueOf(Instant.now().getEpochSecond());
        File directory = new File(SCREENSHOTS);
        if (directory.exists() || directory.mkdirs()) {
            BufferedImage img = new BufferedImage(panel.getSize().width, panel.getSize().height, 1);
            panel.paint(img.createGraphics());
            File imageFile = new File(SCREENSHOTS + timestamp + ".png");
            try {
                if (imageFile.createNewFile()) {
                    ImageIO.write((RenderedImage)img, "png", imageFile);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

