/*
 * Decompiled with CFR 0.152.
 */
package com.templeosrs;

import com.google.inject.Provides;
import com.templeosrs.TempleOSRSConfig;
import com.templeosrs.ui.TempleOSRSPanel;
import com.templeosrs.ui.clans.TempleClans;
import com.templeosrs.ui.competitions.TempleCompetitions;
import com.templeosrs.ui.ranks.TempleRanks;
import com.templeosrs.util.TempleService;
import java.awt.Component;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.SwingUtilities;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.Player;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.menus.MenuManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.xpupdater.XpUpdaterConfig;
import net.runelite.client.plugins.xpupdater.XpUpdaterPlugin;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.Text;

@PluginDependency(value=XpUpdaterPlugin.class)
@PluginDescriptor(name="TempleOSRS", description="A RuneLite plugin utilizing the TempleOSRS API.", tags={"Temple", "ehp", "ehb"})
public class TempleOSRSPlugin
extends Plugin {
    private static final String TEMPLE = "Temple";
    private static final int XP_THRESHOLD = 10000;
    private static NavigationButton navButton;
    public TempleRanks ranks;
    public TempleClans clans;
    public TempleCompetitions competitions;
    public TempleOSRSPanel panel;
    private long lastAccount;
    private boolean fetchXp;
    private long lastXp;
    @Inject
    private Client client;
    @Inject
    private Provider<MenuManager> menuManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private TempleOSRSConfig config;
    @Inject
    private XpUpdaterConfig xpUpdaterConfig;
    @Inject
    private XpUpdaterPlugin xpUpdaterPlugin;
    @Inject
    private TempleService service;

    protected void startUp() {
        this.fetchXp = true;
        this.lastAccount = -1L;
        this.ranks = (TempleRanks)((Object)this.injector.getInstance(TempleRanks.class));
        this.clans = (TempleClans)((Object)this.injector.getInstance(TempleClans.class));
        this.competitions = (TempleCompetitions)((Object)this.injector.getInstance(TempleCompetitions.class));
        this.panel = new TempleOSRSPanel(this.ranks, this.clans, this.competitions);
        navButton = NavigationButton.builder().tooltip("TempleOSRS").icon(ImageUtil.loadImageResource(TempleOSRSPlugin.class, (String)"skills/skill_icon_ehp.png")).priority(5).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(navButton);
        if (this.config.playerLookup() && this.client != null) {
            ((MenuManager)this.menuManager.get()).addPlayerMenuItem(TEMPLE);
        }
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(navButton);
        if (this.client != null) {
            ((MenuManager)this.menuManager.get()).removePlayerMenuItem(TEMPLE);
        }
        this.ranks.shutdown();
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("TempleOSRS")) {
            if (this.client != null) {
                ((MenuManager)this.menuManager.get()).removePlayerMenuItem(TEMPLE);
                if (this.config.playerLookup()) {
                    ((MenuManager)this.menuManager.get()).addPlayerMenuItem(TEMPLE);
                }
                if (this.clans.clanAchievements != null) {
                    this.clans.remove(this.clans.clanAchievements);
                    if (this.config.displayClanAchievements()) {
                        this.clans.add(this.clans.clanAchievements);
                    }
                }
                if (this.clans.clanCurrentTop != null) {
                    this.clans.remove((Component)((Object)this.clans.clanCurrentTop));
                    if (this.config.displayClanCurrentTop()) {
                        this.clans.add((Component)((Object)this.clans.clanCurrentTop));
                    }
                }
                if (this.clans.clanMembers != null) {
                    this.clans.remove((Component)((Object)this.clans.clanMembers));
                    if (this.config.displayClanMembers()) {
                        this.clans.add((Component)((Object)this.clans.clanMembers));
                    }
                }
                this.clans.repaint();
                this.clans.revalidate();
            }
            this.competitions.rebuildWatchlist();
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (event.getType() != MenuAction.CC_OP.getId() && event.getType() != MenuAction.CC_OP_LOW_PRIORITY.getId() || !this.config.playerLookup()) {
            return;
        }
        String username = Text.toJagexName((String)Text.removeTags((String)event.getTarget()).toLowerCase().trim());
        String option = event.getOption();
        int componentId = event.getActionParam1();
        int groupId = WidgetInfo.TO_GROUP((int)componentId);
        if (groupId == WidgetInfo.FRIENDS_LIST.getGroupId() && option.equals("Delete") || groupId == WidgetInfo.FRIENDS_CHAT.getGroupId() && (option.equals("Add ignore") || option.equals("Remove friend")) || groupId == WidgetInfo.CHATBOX.getGroupId() && (option.equals("Add ignore") || option.equals("Message")) || groupId == WidgetInfo.IGNORE_LIST.getGroupId() && option.equals("Delete") || (componentId == WidgetInfo.CLAN_MEMBER_LIST.getId() || componentId == WidgetInfo.CLAN_GUEST_MEMBER_LIST.getId()) && (option.equals("Add ignore") || option.equals("Remove friend")) || groupId == WidgetInfo.PRIVATE_CHAT_MESSAGE.getGroupId() && (option.equals("Add ignore") || option.equals("Message")) || groupId == 726 && (option.equals("Add friend") || option.equals("Remove friend") || option.equals("Remove ignore"))) {
            this.client.createMenuEntry(-2).setOption(TEMPLE).setTarget(event.getTarget()).setType(MenuAction.RUNELITE).setIdentifier(event.getIdentifier()).onClick(e -> this.fetchUser(username));
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() == MenuAction.RUNELITE_PLAYER && event.getMenuOption().equals(TEMPLE)) {
            Player player = this.client.getCachedPlayers()[event.getId()];
            if (player == null) {
                return;
            }
            String username = player.getName();
            this.fetchUser(username);
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        if (this.fetchXp) {
            this.lastXp = this.client.getOverallExperience();
            this.fetchXp = false;
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        GameState state = gameStateChanged.getGameState();
        if (state == GameState.LOGGED_IN) {
            if (this.lastAccount != this.client.getAccountHash()) {
                this.lastAccount = this.client.getAccountHash();
                this.fetchXp = true;
            }
        } else if (state == GameState.LOGIN_SCREEN) {
            Player local = this.client.getLocalPlayer();
            if (local == null) {
                return;
            }
            long totalXp = this.client.getOverallExperience();
            String username = local.getName();
            if (Math.abs(totalXp - this.lastXp) > 10000L && username != null && this.config.autoUpdate()) {
                this.updateUser(this.lastAccount, username.replace(" ", "+"));
                this.lastXp = totalXp;
            }
        }
    }

    @Provides
    TempleOSRSConfig provideConfig(ConfigManager configManager) {
        return (TempleOSRSConfig)configManager.getConfig(TempleOSRSConfig.class);
    }

    public void fetchUser(String username) {
        SwingUtilities.invokeLater(() -> {
            if (!navButton.isSelected()) {
                navButton.getOnSelect().run();
            }
            this.panel.tabGroup.select(this.panel.ranksTab);
            this.ranks.fetchUser(username);
        });
    }

    public void updateUser(long accountHash, String username) {
        if (!this.pluginManager.isPluginEnabled((Plugin)this.xpUpdaterPlugin) || !this.xpUpdaterConfig.templeosrs()) {
            new Thread(() -> {
                try {
                    this.service.addDatapointAsync(username, accountHash);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }).start();
        }
    }
}

