/*
 * Decompiled with CFR 0.152.
 */
package com.globalconsciousness;

import com.globalconsciousness.GlobalConsciousnessConfig;
import com.globalconsciousness.GlobalConsciousnessOverlay;
import com.globalconsciousness.GlobalConsciousnessPanel;
import com.google.inject.Provides;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxItemSearch;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Global Consciousness", description="Channel your inner Rendi to unlock the power of global consciousness and... just get the drop lul.")
public class GlobalConsciousnessPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GlobalConsciousnessPlugin.class);
    static final String CONFIG_GROUP_KEY = "globalconsciousness";
    public String itemName = "";
    public int itemId;
    public int iconSpeed;
    public int iconScale;
    public int iconOpacity;
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private GlobalConsciousnessConfig globalConsciousnessConfig;
    @Inject
    private ChatboxItemSearch itemSearch;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    private NavigationButton navButton;
    private GlobalConsciousnessPanel panel;
    @Inject
    private GlobalConsciousnessOverlay globalConsciousnessOverlay;

    @Provides
    GlobalConsciousnessConfig getConfig(ConfigManager configManager) {
        return (GlobalConsciousnessConfig)configManager.getConfig(GlobalConsciousnessConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        this.itemName = this.globalConsciousnessConfig.itemName();
        this.itemId = this.globalConsciousnessConfig.itemId();
        this.iconSpeed = this.globalConsciousnessConfig.iconSpeed();
        this.iconScale = this.globalConsciousnessConfig.iconScale();
        this.iconOpacity = this.globalConsciousnessConfig.iconOpacity();
        this.panel.currentItemName.setText(this.globalConsciousnessConfig.itemName());
    }

    public void startUp() {
        this.overlayManager.add((Overlay)this.globalConsciousnessOverlay);
        this.globalConsciousnessOverlay.x = 0;
        this.globalConsciousnessOverlay.y = 0;
        this.itemName = this.globalConsciousnessConfig.itemName();
        this.itemId = this.globalConsciousnessConfig.itemId();
        this.iconSpeed = this.globalConsciousnessConfig.iconSpeed();
        this.iconScale = this.globalConsciousnessConfig.iconScale();
        this.iconOpacity = this.globalConsciousnessConfig.iconOpacity();
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"brain-icon.png");
        this.panel = new GlobalConsciousnessPanel(this.client, this.globalConsciousnessConfig, this, this.configManager);
        this.navButton = NavigationButton.builder().tooltip("Global Consciousness").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.globalConsciousnessOverlay);
        this.clientToolbar.removeNavigation(this.navButton);
    }

    public void updateFromSearch() {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            JOptionPane.showMessageDialog((Component)((Object)this.panel), "You must be logged in to search.", "Cannot Search for Item", 0);
            return;
        }
        this.itemSearch.tooltipText("Set item to").onItemSelected(itemId -> this.clientThread.invokeLater(() -> {
            int finalId = this.itemManager.canonicalize(itemId.intValue());
            String itemName = this.itemManager.getItemComposition(finalId).getName();
            this.configManager.setConfiguration(CONFIG_GROUP_KEY, "itemName", itemName);
            this.configManager.setConfiguration(CONFIG_GROUP_KEY, "itemId", (Object)finalId);
        })).build();
    }

    public ClientThread getClientThread() {
        return this.clientThread;
    }
}

