/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.tasktypes.league4;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.JPopupMenu;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.Util;
import net.reldo.taskstracker.panel.TaskPanel;
import net.reldo.taskstracker.panel.filters.AreaFilter;
import net.reldo.taskstracker.panel.filters.CategoryFilter;
import net.reldo.taskstracker.panel.filters.SkillFilter;
import net.reldo.taskstracker.panel.filters.TierFilter;
import net.reldo.taskstracker.tasktypes.RequiredSkill;
import net.reldo.taskstracker.tasktypes.Task;
import net.reldo.taskstracker.tasktypes.league4.League4Task;
import net.reldo.taskstracker.tasktypes.league4.League4TaskTier;
import net.runelite.api.Skill;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ColorScheme;

public class League4TaskPanel
extends TaskPanel {
    public League4TaskPanel(TasksTrackerPlugin plugin, ClientThread clientThread, SpriteManager spriteManager, Task task) {
        super(plugin, clientThread, spriteManager, task);
        this.filters.add(new SkillFilter(plugin.getConfig()));
        this.filters.add(new TierFilter(plugin.getConfig()));
        this.filters.add(new AreaFilter(plugin.getConfig()));
        this.filters.add(new CategoryFilter(plugin.getConfig()));
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return null;
    }

    @Override
    public String getTaskTooltip() {
        League4Task task = (League4Task)this.task;
        Object text = Util.wrapWithBold(task.getName()) + Util.HTML_LINE_BREAK + task.getTier() + this.getPointsTooltipText() + Util.HTML_LINE_BREAK + task.getDescription() + this.getSkillSectionHtml();
        text = Util.wrapWithWrappingParagraph((String)text, 200);
        return Util.wrapWithHtml((String)text);
    }

    @Override
    public BufferedImage getIcon() {
        League4TaskTier tier = League4TaskTier.tiersByName.get(this.task.getTier().toLowerCase());
        if (tier == null) {
            return null;
        }
        return this.spriteManager.getSprite(tier.spriteId, 0);
    }

    @Override
    public Color getTaskBackgroundColor(Task task, int[] playerSkills) {
        if (playerSkills == null) {
            return ColorScheme.DARKER_GRAY_COLOR;
        }
        if (task.isCompleted()) {
            return COMPLETED_BACKGROUND_COLOR;
        }
        for (RequiredSkill requiredSkill : ((League4Task)task).getSkills()) {
            int level;
            Skill skill;
            try {
                skill = Skill.valueOf((String)requiredSkill.skill.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            try {
                level = Integer.parseInt(requiredSkill.level);
            }
            catch (NumberFormatException ex) {
                continue;
            }
            if (playerSkills[skill.ordinal()] >= level) continue;
            return UNQUALIFIED_BACKGROUND_COLOR;
        }
        return ColorScheme.DARKER_GRAY_COLOR;
    }

    private String getPointsTooltipText() {
        int points = this.task.getPoints();
        if (points == 0) {
            return "";
        }
        return " - " + points + " points";
    }

    private String getSkillSectionHtml() {
        StringBuilder skillSection = new StringBuilder();
        League4Task task = (League4Task)this.task;
        for (RequiredSkill requiredSkill : task.getSkills()) {
            int level;
            Skill skill;
            try {
                skill = Skill.valueOf((String)requiredSkill.skill.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                continue;
            }
            try {
                level = Integer.parseInt(requiredSkill.level);
            }
            catch (NumberFormatException ex) {
                continue;
            }
            skillSection.append(Util.HTML_LINE_BREAK);
            int playerLevel = 255;
            if (this.plugin.playerSkills != null) {
                playerLevel = this.plugin.playerSkills[skill.ordinal()];
            }
            skillSection.append(this.getSkillRequirementHtml(requiredSkill.getSkill().toLowerCase(), playerLevel, level));
        }
        return skillSection.toString();
    }

    private String getSkillRequirementHtml(String skillName, int playerLevel, int requiredLevel) {
        String skillIconPath = "/skill_icons_small/" + skillName + ".png";
        URL url = SkillIconManager.class.getResource(skillIconPath);
        Color color = playerLevel >= requiredLevel ? QUALIFIED_TEXT_COLOR : UNQUALIFIED_TEXT_COLOR;
        return Util.imageTag(url) + " " + Util.colorTag(color, playerLevel + "/" + requiredLevel);
    }
}

