/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.tasktypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import net.reldo.taskstracker.data.CallbackCommand;
import net.reldo.taskstracker.data.TaskDataClient;
import net.reldo.taskstracker.tasktypes.Task;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.reldo.taskstracker.tasktypes.TasksSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    private final TaskDataClient taskDataClient;
    public TaskType taskType;
    public HashMap<Integer, Task> tasks = new HashMap();

    public TaskManager(TaskType taskType, TaskDataClient taskDataClient) {
        this.taskType = taskType;
        this.taskDataClient = taskDataClient;
    }

    public void asyncLoadTaskSourceData(CallbackCommand<ArrayList<Task>> callback) {
        this.taskDataClient.loadTaskSourceData(this.taskType, tasks -> {
            this.tasks = tasks.stream().collect(Collectors.toMap(Task::getId, v -> v, (prev, next) -> next, HashMap::new));
            callback.execute((ArrayList<Task>)tasks);
        });
    }

    public void applyTrackerSave(HashMap<Integer, Task> loadedTasks) {
        log.debug("applyTrackerSave");
        if (loadedTasks == null) {
            return;
        }
        this.tasks.values().forEach(task -> {
            Task loadedTask = (Task)loadedTasks.get(task.getId());
            if (loadedTask == null) {
                return;
            }
            task.loadConfigSave(loadedTask);
        });
    }

    public TasksSummary getSummary() {
        return new TasksSummary(this.tasks.values());
    }
}

