/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.tasktypes;

import com.google.gson.annotations.Expose;
import java.time.Instant;
import java.util.Arrays;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.data.reldo.ReldoTaskSave;
import net.reldo.taskstracker.panel.TaskPanel;
import net.reldo.taskstracker.tasktypes.RequiredSkill;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.SpriteManager;

public abstract class Task {
    @Expose
    private final int id;
    private final String name;
    private final String description;
    private final String tier;
    private final int clientSortId;
    @Expose
    private long completedOn;
    @Expose
    private long trackedOn;
    @Expose
    private long ignoredOn;
    private RequiredSkill[] skills = null;
    private String area;
    private String taskCategory;

    public boolean isCompleted() {
        return this.completedOn > 0L;
    }

    public int getPoints() {
        return 0;
    }

    public void setCompleted(boolean completed) {
        long now = Instant.now().toEpochMilli();
        if (completed && this.completedOn > 0L && this.completedOn <= now) {
            return;
        }
        this.completedOn = completed ? now : 0L;
    }

    public boolean isTracked() {
        return this.trackedOn > 0L;
    }

    public void setTracked(boolean state) {
        long now = Instant.now().toEpochMilli();
        if (state && this.trackedOn > 0L && this.trackedOn <= now) {
            return;
        }
        this.trackedOn = state ? now : 0L;
    }

    public boolean isIgnored() {
        return this.ignoredOn > 0L;
    }

    public void setIgnored(boolean state) {
        long now = Instant.now().toEpochMilli();
        if (state && this.ignoredOn > 0L && this.ignoredOn <= now) {
            return;
        }
        this.ignoredOn = state ? now : 0L;
    }

    public void loadConfigSave(Task loadedData) {
        this.setDates(loadedData.getCompletedOn(), loadedData.getIgnoredOn(), loadedData.getTrackedOn());
    }

    public void loadReldoSave(ReldoTaskSave loadedData) {
        this.setMostRecentDates(loadedData.getCompleted(), loadedData.getIgnored(), loadedData.getTodo());
    }

    private void setDates(long completedOn, long ignoredOn, long trackedOn) {
        this.setCompletedOn(completedOn);
        this.setIgnoredOn(ignoredOn);
        this.setTrackedOn(trackedOn);
    }

    private void setMostRecentDates(long completedOn, long ignoredOn, long trackedOn) {
        if (completedOn < this.getCompletedOn()) {
            this.setCompletedOn(completedOn);
        }
        if (ignoredOn > this.getIgnoredOn()) {
            this.setIgnoredOn(ignoredOn);
        }
        if (trackedOn > this.getTrackedOn()) {
            this.setTrackedOn(trackedOn);
        }
    }

    public abstract TaskType getType();

    public abstract TaskPanel generatePanel(TasksTrackerPlugin var1, ClientThread var2, SpriteManager var3, SkillIconManager var4);

    public Task(int id, String name, String description, String tier, int clientSortId) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.tier = tier;
        this.clientSortId = clientSortId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTier() {
        return this.tier;
    }

    public int getClientSortId() {
        return this.clientSortId;
    }

    public long getCompletedOn() {
        return this.completedOn;
    }

    public long getTrackedOn() {
        return this.trackedOn;
    }

    public long getIgnoredOn() {
        return this.ignoredOn;
    }

    public RequiredSkill[] getSkills() {
        return this.skills;
    }

    public String getArea() {
        return this.area;
    }

    public String getTaskCategory() {
        return this.taskCategory;
    }

    public void setCompletedOn(long completedOn) {
        this.completedOn = completedOn;
    }

    public void setTrackedOn(long trackedOn) {
        this.trackedOn = trackedOn;
    }

    public void setIgnoredOn(long ignoredOn) {
        this.ignoredOn = ignoredOn;
    }

    public void setSkills(RequiredSkill[] skills) {
        this.skills = skills;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public void setTaskCategory(String taskCategory) {
        this.taskCategory = taskCategory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Task)) {
            return false;
        }
        Task other = (Task)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getClientSortId() != other.getClientSortId()) {
            return false;
        }
        if (this.getCompletedOn() != other.getCompletedOn()) {
            return false;
        }
        if (this.getTrackedOn() != other.getTrackedOn()) {
            return false;
        }
        if (this.getIgnoredOn() != other.getIgnoredOn()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$tier = this.getTier();
        String other$tier = other.getTier();
        if (this$tier == null ? other$tier != null : !this$tier.equals(other$tier)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getSkills(), other.getSkills())) {
            return false;
        }
        String this$area = this.getArea();
        String other$area = other.getArea();
        if (this$area == null ? other$area != null : !this$area.equals(other$area)) {
            return false;
        }
        String this$taskCategory = this.getTaskCategory();
        String other$taskCategory = other.getTaskCategory();
        return !(this$taskCategory == null ? other$taskCategory != null : !this$taskCategory.equals(other$taskCategory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Task;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + this.getClientSortId();
        long $completedOn = this.getCompletedOn();
        result = result * 59 + (int)($completedOn >>> 32 ^ $completedOn);
        long $trackedOn = this.getTrackedOn();
        result = result * 59 + (int)($trackedOn >>> 32 ^ $trackedOn);
        long $ignoredOn = this.getIgnoredOn();
        result = result * 59 + (int)($ignoredOn >>> 32 ^ $ignoredOn);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $tier = this.getTier();
        result = result * 59 + ($tier == null ? 43 : $tier.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getSkills());
        String $area = this.getArea();
        result = result * 59 + ($area == null ? 43 : $area.hashCode());
        String $taskCategory = this.getTaskCategory();
        result = result * 59 + ($taskCategory == null ? 43 : $taskCategory.hashCode());
        return result;
    }

    public String toString() {
        return "Task(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", tier=" + this.getTier() + ", clientSortId=" + this.getClientSortId() + ", completedOn=" + this.getCompletedOn() + ", trackedOn=" + this.getTrackedOn() + ", ignoredOn=" + this.getIgnoredOn() + ", skills=" + Arrays.deepToString(this.getSkills()) + ", area=" + this.getArea() + ", taskCategory=" + this.getTaskCategory() + ")";
    }
}

