/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.panel.subfilters;

import com.google.common.collect.ImmutableList;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.panel.subfilters.FilterButtonPanel;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.runelite.client.hiscore.HiscoreSkill;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class SkillFilterPanel
extends FilterButtonPanel {
    private static final List<HiscoreSkill> SKILLS = ImmutableList.of((Object)HiscoreSkill.ATTACK, (Object)HiscoreSkill.HITPOINTS, (Object)HiscoreSkill.MINING, (Object)HiscoreSkill.STRENGTH, (Object)HiscoreSkill.AGILITY, (Object)HiscoreSkill.SMITHING, (Object)HiscoreSkill.DEFENCE, (Object)HiscoreSkill.HERBLORE, (Object)HiscoreSkill.FISHING, (Object)HiscoreSkill.RANGED, (Object)HiscoreSkill.THIEVING, (Object)HiscoreSkill.COOKING, (Object[])new HiscoreSkill[]{HiscoreSkill.PRAYER, HiscoreSkill.CRAFTING, HiscoreSkill.FIREMAKING, HiscoreSkill.MAGIC, HiscoreSkill.FLETCHING, HiscoreSkill.WOODCUTTING, HiscoreSkill.RUNECRAFT, HiscoreSkill.SLAYER, HiscoreSkill.FARMING, HiscoreSkill.CONSTRUCTION, HiscoreSkill.HUNTER});

    public SkillFilterPanel(TasksTrackerPlugin plugin) {
        super(plugin, "Skill");
        this.configKey = "skillFilter";
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.redraw();
    }

    @Override
    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(8, 3));
        buttonPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        LinkedHashMap<String, BufferedImage> skillImages = this.getIconImages();
        skillImages.forEach((name, image) -> {
            JToggleButton button = this.makeButton((String)name, (BufferedImage)image);
            this.buttons.put(name, button);
            buttonPanel.add(button);
        });
        ((JToggleButton)this.buttons.get("noskill")).setToolTipText("No skill requirements.");
        return buttonPanel;
    }

    @Override
    protected LinkedHashMap<String, BufferedImage> getIconImages() {
        BufferedImage skillImage;
        String skillName;
        LinkedHashMap<String, BufferedImage> images = new LinkedHashMap<String, BufferedImage>();
        for (HiscoreSkill skill : SKILLS) {
            skillName = skill.name().toLowerCase();
            String directory = "/skill_icons_small/";
            String skillIcon = directory + skillName + ".png";
            skillImage = ImageUtil.loadImageResource(this.getClass(), (String)skillIcon);
            images.put(skillName, skillImage);
        }
        skillName = "noskill";
        skillImage = ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/no_skill.png");
        images.put(skillName, skillImage);
        return images;
    }

    @Override
    public void redraw() {
        if (this.plugin.getConfig().taskType() != null) {
            this.setVisible(!this.plugin.getConfig().taskType().equals((Object)TaskType.COMBAT));
        }
        super.redraw();
    }
}

