/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.panel.subfilters;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicButtonUI;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.panel.components.FixedWidthPanel;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;

public abstract class FilterButtonPanel
extends FixedWidthPanel {
    protected final TasksTrackerPlugin plugin;
    private final String name;
    protected final Map<String, JToggleButton> buttons = new HashMap<String, JToggleButton>();
    protected String configKey;
    protected JPanel buttonPanel;
    protected JToggleButton collapseBtn;
    private final String expandBtnPath = "panel/components/";
    private final BufferedImage collapseImg = ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/filter_buttons_collapsed.png");
    private final Icon MENU_COLLAPSED_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)this.collapseImg, (int)-180));
    private final Icon MENU_ICON_HOVER = new ImageIcon(this.collapseImg);
    private final BufferedImage expandedImg = ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/filter_buttons_expanded.png");
    private final Icon MENU_EXPANDED_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)this.expandedImg, (int)-180));
    private final Icon MENU_ICON_HOVER_SELECTED = new ImageIcon(this.expandedImg);

    public FilterButtonPanel(TasksTrackerPlugin plugin, String name) {
        this.plugin = plugin;
        this.name = name;
    }

    protected abstract LinkedHashMap<String, BufferedImage> getIconImages();

    protected abstract JPanel makeButtonPanel();

    protected JToggleButton makeButton(String name, BufferedImage image) {
        JToggleButton button = new JToggleButton();
        button.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        button.setBorder(new EmptyBorder(2, 0, 2, 0));
        button.setFocusable(false);
        if (image != null) {
            ImageIcon selectedIcon = new ImageIcon(image);
            ImageIcon deselectedIcon = new ImageIcon(ImageUtil.alphaOffset((Image)image, (int)-180));
            button.setIcon(deselectedIcon);
            button.setSelectedIcon(selectedIcon);
        }
        button.setToolTipText(name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase());
        button.addActionListener(e -> {
            this.updateFilterText();
            this.updateCollapseButtonText();
            this.plugin.refresh();
        });
        button.setSelected(true);
        return button;
    }

    protected JPanel allOrNoneButtons() {
        JPanel buttonWrapper = new JPanel();
        buttonWrapper.setLayout(new BoxLayout(buttonWrapper, 0));
        buttonWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        buttonWrapper.setAlignmentX(0.5f);
        JButton all = new JButton("all");
        SwingUtil.removeButtonDecorations((AbstractButton)all);
        all.setFocusable(false);
        all.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
        all.setFont(FontManager.getRunescapeSmallFont());
        all.addActionListener(e -> {
            this.setAllSelected(true);
            this.updateFilterText();
            this.updateCollapseButtonText();
            this.plugin.refresh();
        });
        JButton none = new JButton("none");
        SwingUtil.removeButtonDecorations((AbstractButton)none);
        none.setFocusable(false);
        none.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
        none.setFont(FontManager.getRunescapeSmallFont());
        none.addActionListener(e -> {
            this.setAllSelected(false);
            this.updateFilterText();
            this.updateCollapseButtonText();
            this.plugin.refresh();
        });
        JLabel separator = new JLabel("|");
        separator.setForeground(ColorScheme.MEDIUM_GRAY_COLOR);
        buttonWrapper.add(all);
        buttonWrapper.add(separator);
        buttonWrapper.add(none);
        return buttonWrapper;
    }

    public JToggleButton makeCollapseButton() {
        JToggleButton collapseBtn = new JToggleButton();
        SwingUtil.removeButtonDecorations((AbstractButton)collapseBtn);
        collapseBtn.setIcon(this.MENU_COLLAPSED_ICON);
        collapseBtn.setSelectedIcon(this.MENU_EXPANDED_ICON);
        collapseBtn.setRolloverIcon(this.MENU_ICON_HOVER);
        collapseBtn.setRolloverSelectedIcon(this.MENU_ICON_HOVER_SELECTED);
        SwingUtil.addModalTooltip((AbstractButton)collapseBtn, (String)"Collapse filters", (String)"Expand filters");
        collapseBtn.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        collapseBtn.setAlignmentX(0.0f);
        collapseBtn.setUI(new BasicButtonUI());
        collapseBtn.addActionListener(ev -> this.buttonPanel.setVisible(!this.buttonPanel.isVisible()));
        collapseBtn.setHorizontalTextPosition(0);
        collapseBtn.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        collapseBtn.setFont(FontManager.getRunescapeSmallFont());
        collapseBtn.setSelected(true);
        return collapseBtn;
    }

    protected void updateFilterText() {
        String filterText = this.buttons.entrySet().stream().filter(e -> ((JToggleButton)e.getValue()).isSelected()).map(e -> "f-" + (String)e.getKey()).collect(Collectors.joining(","));
        this.plugin.getConfigManager().setConfiguration("tasks-tracker", this.configKey, filterText);
    }

    protected void setAllSelected(boolean state) {
        this.buttons.values().forEach(button -> button.setSelected(state));
    }

    protected void updateCollapseButtonText() {
        this.collapseBtn.setText(this.name + " - " + this.buttons.values().stream().filter(AbstractButton::isSelected).count() + " / " + this.buttons.size());
    }

    public void redraw() {
        assert (SwingUtilities.isEventDispatchThread());
        this.buttons.clear();
        this.removeAll();
        this.collapseBtn = this.makeCollapseButton();
        this.buttonPanel = this.makeButtonPanel();
        this.add((Component)this.collapseBtn, "North");
        this.add((Component)this.buttonPanel, "Center");
        this.add((Component)this.allOrNoneButtons(), "South");
        this.updateFilterText();
        this.updateCollapseButtonText();
        this.collapseBtn.setVisible(this.plugin.getConfig().filterPanelCollapsible());
        this.validate();
        this.repaint();
    }
}

