/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.panel.subfilters;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.panel.subfilters.FilterButtonPanel;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.reldo.taskstracker.tasktypes.combattask.CombatTaskTier;
import net.reldo.taskstracker.tasktypes.league4.League4TaskTier;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class DifficultyFilterPanel
extends FilterButtonPanel {
    public DifficultyFilterPanel(TasksTrackerPlugin plugin, SpriteManager spriteManager) {
        super(plugin, "Tier");
        this.configKey = "tierFilter";
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.redraw();
    }

    @Override
    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        LinkedHashMap<String, BufferedImage> buttonImages = this.getIconImages();
        buttonPanel.setLayout(new GridLayout(buttonImages.size() / 3, 3));
        buttonImages.forEach((name, image) -> {
            JToggleButton button = this.makeButton((String)name, (BufferedImage)image);
            this.buttons.put(name, button);
            buttonPanel.add(button);
        });
        return buttonPanel;
    }

    @Override
    protected LinkedHashMap<String, BufferedImage> getIconImages() {
        BufferedImage tierImage;
        String tierIcon;
        String tierName;
        LinkedHashMap<String, BufferedImage> images = new LinkedHashMap<String, BufferedImage>();
        Object directory = "panel/components/task_tiers/";
        if (this.plugin.getConfig().taskType() == null) {
            return images;
        }
        if (this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_3) || this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_4)) {
            directory = (String)directory + "league3/";
            for (League4TaskTier league4TaskTier : League4TaskTier.values()) {
                tierName = league4TaskTier.name().toLowerCase();
                tierIcon = (String)directory + tierName + ".png";
                tierImage = ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)tierIcon);
                images.put(tierName, tierImage);
            }
        }
        if (this.plugin.getConfig().taskType().equals((Object)TaskType.COMBAT)) {
            directory = (String)directory + "combat/";
            for (Enum enum_ : CombatTaskTier.values()) {
                tierName = enum_.name().toLowerCase();
                tierIcon = (String)directory + tierName + ".png";
                tierImage = ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)tierIcon);
                images.put(tierName, tierImage);
            }
        }
        return images;
    }
}

