/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.panel.subfilters;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.panel.subfilters.FilterButtonPanel;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.reldo.taskstracker.tasktypes.league4.League4TaskCategory;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class CategoryFilterPanel
extends FilterButtonPanel {
    public CategoryFilterPanel(TasksTrackerPlugin plugin, SpriteManager spriteManager) {
        super(plugin, "Category");
        this.configKey = "categoryFilter";
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.redraw();
    }

    @Override
    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        LinkedHashMap<String, BufferedImage> buttonImages = this.getIconImages();
        buttonPanel.setLayout(new GridLayout(buttonImages.size() / 3, 3));
        buttonImages.forEach((name, image) -> {
            JToggleButton button = this.makeButton((String)name, (BufferedImage)image);
            this.buttons.put(name, button);
            buttonPanel.add(button);
        });
        return buttonPanel;
    }

    @Override
    protected LinkedHashMap<String, BufferedImage> getIconImages() {
        LinkedHashMap<String, BufferedImage> images = new LinkedHashMap<String, BufferedImage>();
        Object directory = "panel/components/task_categories/";
        if (this.plugin.getConfig().taskType() == null || this.plugin.getConfig().taskType().equals((Object)TaskType.COMBAT) || this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_3)) {
            return images;
        }
        if (this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_4)) {
            directory = (String)directory + "league4/";
            for (League4TaskCategory category : League4TaskCategory.values()) {
                String categoryName = category.name().toLowerCase();
                String categoryIcon = (String)directory + categoryName + ".png";
                BufferedImage categoryImage = ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)categoryIcon);
                images.put(categoryName, categoryImage);
            }
        }
        return images;
    }

    @Override
    public void redraw() {
        if (this.plugin.getConfig().taskType() != null) {
            this.setVisible(this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_4));
        }
        super.redraw();
    }
}

