/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.panel.subfilters;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.util.LinkedHashMap;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.panel.subfilters.FilterButtonPanel;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.reldo.taskstracker.tasktypes.league4.League4TaskArea;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.util.ImageUtil;

public class AreaFilterPanel
extends FilterButtonPanel {
    public AreaFilterPanel(TasksTrackerPlugin plugin, SpriteManager spriteManager) {
        super(plugin, "Area");
        this.configKey = "areaFilter";
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.redraw();
    }

    @Override
    protected JPanel makeButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        LinkedHashMap<String, BufferedImage> buttonImages = this.getIconImages();
        buttonPanel.setLayout(new GridLayout(buttonImages.size() / 3, 3));
        buttonImages.forEach((name, image) -> {
            JToggleButton button = this.makeButton((String)name, (BufferedImage)image);
            this.buttons.put(name, button);
            buttonPanel.add(button);
        });
        return buttonPanel;
    }

    @Override
    protected LinkedHashMap<String, BufferedImage> getIconImages() {
        LinkedHashMap<String, BufferedImage> images = new LinkedHashMap<String, BufferedImage>();
        Object directory = "panel/components/task_areas/";
        if (this.plugin.getConfig().taskType() == null || this.plugin.getConfig().taskType().equals((Object)TaskType.COMBAT) || this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_3)) {
            return images;
        }
        if (this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_4)) {
            directory = (String)directory + "league4/";
            for (League4TaskArea area : League4TaskArea.values()) {
                String areaName = area.name().toLowerCase();
                String areaIcon = (String)directory + areaName + ".png";
                BufferedImage areaImage = ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)areaIcon);
                images.put(areaName, areaImage);
            }
        }
        return images;
    }

    @Override
    public void redraw() {
        if (this.plugin.getConfig().taskType() != null) {
            this.setVisible(this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_4));
        }
        assert (SwingUtilities.isEventDispatchThread());
        this.buttons.clear();
        this.removeAll();
        this.collapseBtn = this.makeCollapseButton();
        this.buttonPanel = this.makeButtonPanel();
        this.add((Component)this.collapseBtn, "North");
        this.add((Component)this.buttonPanel, "Center");
        this.add((Component)this.allOrNoneButtons(), "South");
        if (this.plugin.getConfig().saveAreaFilterState()) {
            String filterText = this.plugin.getConfig().areaFilter();
            this.buttons.forEach((key, value) -> value.setSelected(filterText.contains("f-" + key)));
        } else {
            this.updateFilterText();
        }
        this.updateCollapseButtonText();
        this.collapseBtn.setVisible(this.plugin.getConfig().filterPanelCollapsible());
        this.validate();
        this.repaint();
    }
}

