/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.panel.filters;

import java.util.Arrays;
import net.reldo.taskstracker.TasksTrackerConfig;
import net.reldo.taskstracker.panel.filters.Filter;
import net.reldo.taskstracker.tasktypes.Task;

public class SkillFilter
extends Filter {
    private final TasksTrackerConfig config;

    public SkillFilter(TasksTrackerConfig config) {
        this.config = config;
    }

    @Override
    public boolean meetsCriteria(Task task) {
        if (task.getSkills() == null) {
            return true;
        }
        String skillFilter = this.config.skillFilter();
        if (task.getSkills().length > 0 && !Arrays.stream(task.getSkills()).filter(skill -> !skill.getSkill().equalsIgnoreCase("combat")).allMatch(skill -> skillFilter.contains(skill.getSkill().toLowerCase()))) {
            return false;
        }
        return Arrays.stream(task.getSkills()).anyMatch(skill -> !skill.getSkill().equalsIgnoreCase("combat")) || skillFilter.contains("noskill");
    }
}

