/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.panel;

import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.reldo.taskstracker.TasksTrackerConfig;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.panel.LoggedInPanel;
import net.reldo.taskstracker.panel.LoggedOutPanel;
import net.reldo.taskstracker.panel.TaskListPanel;
import net.reldo.taskstracker.tasktypes.Task;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasksTrackerPluginPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(TasksTrackerPluginPanel.class);
    private final ClientThread clientThread;
    private final SpriteManager spriteManager;
    private final TasksTrackerPlugin plugin;
    private final SkillIconManager skillIconManager;
    private final LoggedInPanel loggedInPanel;
    private final LoggedOutPanel loggedOutPanel = new LoggedOutPanel();
    public TaskListPanel taskListPanel;
    private boolean loggedIn = false;

    public TasksTrackerPluginPanel(TasksTrackerPlugin plugin, TasksTrackerConfig config, ClientThread clientThread, SpriteManager spriteManager, SkillIconManager skillIconManager) {
        super(false);
        this.plugin = plugin;
        this.clientThread = clientThread;
        this.spriteManager = spriteManager;
        this.skillIconManager = skillIconManager;
        this.setBorder(new EmptyBorder(6, 6, 6, 6));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new BorderLayout());
        this.loggedInPanel = new LoggedInPanel(plugin, config, clientThread, spriteManager, skillIconManager);
        this.taskListPanel = this.loggedInPanel.taskListPanel;
        this.add(this.loggedInPanel, "North");
        this.loggedInPanel.setVisible(false);
        this.add(this.loggedOutPanel);
    }

    public Dimension getPreferredSize() {
        return new Dimension(242, super.getPreferredSize().height);
    }

    public void redraw() {
        if (this.loggedIn) {
            this.loggedInPanel.redraw();
        }
    }

    public void refresh(Task task) {
        if (this.loggedIn) {
            this.loggedInPanel.refresh(task);
        }
    }

    public void setLoggedIn(boolean loggedIn) {
        assert (SwingUtilities.isEventDispatchThread());
        if (loggedIn != this.loggedIn) {
            if (loggedIn) {
                this.loggedOutPanel.setVisible(false);
                this.loggedInPanel.setVisible(true);
            } else {
                this.loggedInPanel.setVisible(false);
                this.loggedOutPanel.setVisible(true);
            }
            this.validate();
            this.repaint();
        }
        this.loggedIn = loggedIn;
    }
}

