/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import net.reldo.taskstracker.TasksTrackerConfig;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.Util;
import net.reldo.taskstracker.config.ConfigValues;
import net.reldo.taskstracker.panel.filters.Filter;
import net.reldo.taskstracker.tasktypes.Task;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.components.shadowlabel.JShadowedLabel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TaskPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(TaskPanel.class);
    public static Color QUALIFIED_TEXT_COLOR = new Color(34, 177, 77);
    public static Color UNQUALIFIED_TEXT_COLOR = new Color(251, 93, 93);
    public static Color COMPLETED_BACKGROUND_COLOR = new Color(0, 50, 0);
    public static Color UNQUALIFIED_BACKGROUND_COLOR = new Color(70, 30, 0);
    public static ImageIcon PLUS_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"plus.png"));
    public static ImageIcon MINUS_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"minus.png"));
    public static ImageIcon EYE_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"eye.png"));
    public static ImageIcon EYE_CROSS_GREY = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"eye-cross-grey.png"));
    public final SpriteManager spriteManager;
    public final Task task;
    private final ClientThread clientThread;
    private final JLabel icon = new JLabel();
    private final JPanel container = new JPanel(new BorderLayout());
    private final JPanel body = new JPanel(new BorderLayout());
    private final JShadowedLabel name = new JShadowedLabel();
    private final JLabel description = new JLabel();
    private final JPanel buttons = new JPanel();
    private final JToggleButton toggleTrack = new JToggleButton();
    private final JToggleButton toggleIgnore = new JToggleButton();
    protected final ArrayList<Filter> filters = new ArrayList();
    protected TasksTrackerPlugin plugin;

    public TaskPanel(TasksTrackerPlugin plugin, ClientThread clientThread, SpriteManager spriteManager, Task task) {
        super(new BorderLayout());
        this.plugin = plugin;
        this.clientThread = clientThread;
        this.spriteManager = spriteManager;
        this.task = task;
        this.createPanel(task);
        this.setComponentPopupMenu(this.getPopupMenu());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.refresh();
    }

    public abstract JPopupMenu getPopupMenu();

    public abstract String getTaskTooltip();

    public abstract BufferedImage getIcon();

    public Color getTaskBackgroundColor(Task task, int[] playerSkills) {
        return task.isCompleted() ? COMPLETED_BACKGROUND_COLOR : ColorScheme.DARKER_GRAY_COLOR;
    }

    public void createPanel(Task task) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 7, 0));
        this.container.setBorder(new EmptyBorder(7, 7, 6, 0));
        this.name.setFont(FontManager.getRunescapeSmallFont());
        this.name.setForeground(Color.WHITE);
        this.body.add((Component)this.name, "North");
        this.description.setFont(FontManager.getRunescapeSmallFont());
        this.description.setForeground(Color.GRAY);
        this.body.add((Component)this.description, "Center");
        this.buttons.setLayout(new BoxLayout(this.buttons, 1));
        this.buttons.setBorder(new EmptyBorder(0, 0, 0, 7));
        this.toggleTrack.setPreferredSize(new Dimension(8, 8));
        this.toggleTrack.setIcon(PLUS_ICON);
        this.toggleTrack.setSelectedIcon(MINUS_ICON);
        this.toggleTrack.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.toggleTrack.addActionListener(e -> {
            task.setTracked(this.toggleTrack.isSelected());
            this.plugin.pluginPanel.taskListPanel.refresh(task);
            this.plugin.saveCurrentTaskData();
        });
        SwingUtil.removeButtonDecorations((AbstractButton)this.toggleTrack);
        this.toggleIgnore.setPreferredSize(new Dimension(8, 8));
        this.toggleIgnore.setIcon(EYE_CROSS_GREY);
        this.toggleIgnore.setSelectedIcon(EYE_ICON);
        SwingUtil.addModalTooltip((AbstractButton)this.toggleIgnore, (String)"Unignore", (String)"Ignore");
        this.toggleIgnore.setBorder(new EmptyBorder(5, 0, 5, 0));
        this.toggleIgnore.addActionListener(e -> {
            task.setIgnored(!task.isIgnored());
            this.plugin.pluginPanel.taskListPanel.refresh(task);
            this.plugin.saveCurrentTaskData();
        });
        SwingUtil.removeButtonDecorations((AbstractButton)this.toggleIgnore);
        this.buttons.add(this.toggleTrack);
        this.buttons.add(this.toggleIgnore);
        this.container.add((Component)this.icon, "West");
        this.container.add((Component)this.body, "Center");
        this.container.add((Component)this.buttons, "East");
        this.clientThread.invoke(() -> {
            if (this.getIcon() != null) {
                this.icon.setMinimumSize(new Dimension(36, 32));
                this.icon.setIcon(new ImageIcon(this.getIcon()));
                this.icon.setBorder(new EmptyBorder(0, 0, 0, 5));
            } else {
                this.icon.setBorder(new EmptyBorder(0, 0, 0, 0));
            }
        });
        this.add((Component)this.container, "North");
    }

    public void refresh() {
        this.name.setText(Util.wrapWithHtml(this.task.getName()));
        this.description.setText(Util.wrapWithHtml(this.task.getDescription()));
        this.setBackgroundColor(this.getTaskBackgroundColor(this.task, this.plugin.playerSkills));
        this.toggleTrack.setSelected(this.task.isTracked());
        this.toggleIgnore.setSelected(this.task.isIgnored());
        this.setVisible(this.meetsFilterCriteria());
        this.revalidate();
    }

    protected boolean meetsFilterCriteria() {
        String nameLowercase = this.task.getName().toLowerCase();
        String descriptionLowercase = this.task.getDescription().toLowerCase();
        if (this.plugin.taskTextFilter != null && !nameLowercase.contains(this.plugin.taskTextFilter) && !descriptionLowercase.contains(this.plugin.taskTextFilter)) {
            return false;
        }
        TasksTrackerConfig config = this.plugin.getConfig();
        for (Filter filter : this.filters) {
            if (filter.meetsCriteria(this.task)) continue;
            return false;
        }
        if (config.completedFilter().equals((Object)ConfigValues.CompletedFilterValues.INCOMPLETE) && this.task.isCompleted()) {
            return false;
        }
        if (config.completedFilter().equals((Object)ConfigValues.CompletedFilterValues.COMPLETE) && !this.task.isCompleted()) {
            return false;
        }
        if (config.ignoredFilter().equals((Object)ConfigValues.IgnoredFilterValues.NOT_IGNORED) && this.task.isIgnored()) {
            return false;
        }
        if (config.ignoredFilter().equals((Object)ConfigValues.IgnoredFilterValues.IGNORED) && !this.task.isIgnored()) {
            return false;
        }
        if (config.trackedFilter().equals((Object)ConfigValues.TrackedFilterValues.UNTRACKED) && this.task.isTracked()) {
            return false;
        }
        return !config.trackedFilter().equals((Object)ConfigValues.TrackedFilterValues.TRACKED) || this.task.isTracked();
    }

    private void setBackgroundColor(Color color) {
        this.container.setBackground(color);
        this.body.setBackground(color);
        this.buttons.setBackground(color);
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(225, this.getPreferredSize().height);
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip customTooltip = new JToolTip();
        customTooltip.setFont(FontManager.getRunescapeSmallFont());
        return customTooltip;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getTaskTooltip();
    }
}

