/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.panel;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.panel.TaskPanel;
import net.reldo.taskstracker.panel.components.FixedWidthPanel;
import net.reldo.taskstracker.tasktypes.Task;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.FontManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskListPanel
extends JScrollPane {
    private static final Logger log = LoggerFactory.getLogger(TaskListPanel.class);
    public TasksTrackerPlugin plugin;
    public final ArrayList<TaskPanel> taskPanels = new ArrayList();
    private final ClientThread clientThread;
    private final SpriteManager spriteManager;
    private final SkillIconManager skillIconManager;
    private final TaskListListPanel taskList;
    private final JLabel emptyTasks = new JLabel();

    public TaskListPanel(TasksTrackerPlugin plugin, ClientThread clientThread, SpriteManager spriteManager, SkillIconManager skillIconManager) {
        this.plugin = plugin;
        this.clientThread = clientThread;
        this.spriteManager = spriteManager;
        this.skillIconManager = skillIconManager;
        this.taskList = new TaskListListPanel();
        this.setViewportView(this.taskList);
        this.setHorizontalScrollBarPolicy(31);
    }

    public Collection<Task> getTasks() {
        if (this.plugin.getConfig().taskType() == null) {
            return null;
        }
        return this.plugin.taskManagers.get((Object)((Object)this.plugin.getConfig().taskType())).tasks.values().stream().sorted(Comparator.comparing(Task::getClientSortId)).collect(Collectors.toList());
    }

    public String getEmptyTaskListMessage() {
        return "No tasks match the current filters.";
    }

    public void redraw() {
        this.taskList.redraw();
    }

    public void refresh(Task task) {
        assert (SwingUtilities.isEventDispatchThread());
        this.emptyTasks.setVisible(false);
        if (task != null) {
            Optional<TaskPanel> panel = this.taskPanels.stream().filter(tp -> tp.task.getName().equalsIgnoreCase(task.getName())).findFirst();
            panel.ifPresent(TaskPanel::refresh);
        } else {
            for (TaskPanel taskPanel : this.taskPanels) {
                taskPanel.refresh();
            }
        }
        Optional<TaskPanel> visibleTaskPanel = this.taskPanels.stream().filter(Component::isVisible).findFirst();
        if (!visibleTaskPanel.isPresent()) {
            this.emptyTasks.setVisible(true);
        }
    }

    private class TaskListListPanel
    extends FixedWidthPanel {
        public TaskListListPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(new EmptyBorder(0, 10, 10, 10));
            this.setAlignmentX(0.0f);
            TaskListPanel.this.emptyTasks.setBorder(new EmptyBorder(10, 0, 10, 0));
            TaskListPanel.this.emptyTasks.setText("<html><center>" + TaskListPanel.this.getEmptyTaskListMessage() + "</center></html>");
            TaskListPanel.this.emptyTasks.setFont(FontManager.getRunescapeSmallFont());
            TaskListPanel.this.emptyTasks.setHorizontalAlignment(0);
            TaskListPanel.this.emptyTasks.setVerticalAlignment(0);
            this.add(TaskListPanel.this.emptyTasks);
            TaskListPanel.this.emptyTasks.setVisible(false);
        }

        public void redraw() {
            assert (SwingUtilities.isEventDispatchThread());
            this.removeAll();
            TaskListPanel.this.taskPanels.clear();
            this.add(TaskListPanel.this.emptyTasks);
            TaskListPanel.this.emptyTasks.setVisible(false);
            log.debug(" Creating panels...");
            Collection<Task> tasks = TaskListPanel.this.getTasks();
            if (tasks == null || tasks.size() == 0) {
                TaskListPanel.this.emptyTasks.setVisible(true);
                return;
            }
            for (Task task : tasks) {
                TaskPanel taskPanel = task.generatePanel(TaskListPanel.this.plugin, TaskListPanel.this.clientThread, TaskListPanel.this.spriteManager, TaskListPanel.this.skillIconManager);
                this.add(taskPanel);
                TaskListPanel.this.taskPanels.add(taskPanel);
            }
            log.debug("Validated and repaint...");
            this.validate();
            this.repaint();
        }
    }
}

