/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicButtonUI;
import net.reldo.taskstracker.TasksTrackerConfig;
import net.reldo.taskstracker.TasksTrackerPlugin;
import net.reldo.taskstracker.config.ConfigValues;
import net.reldo.taskstracker.panel.SubFilterPanel;
import net.reldo.taskstracker.panel.TaskListPanel;
import net.reldo.taskstracker.panel.components.SearchBox;
import net.reldo.taskstracker.panel.components.TriToggleButton;
import net.reldo.taskstracker.tasktypes.Task;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.SwingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggedInPanel
extends JPanel
implements ChangeListener {
    private static final Logger log = LoggerFactory.getLogger(LoggedInPanel.class);
    public TaskListPanel taskListPanel;
    private JComboBox<TaskType> taskTypeDropdown;
    private final TasksTrackerPlugin plugin;
    private final ClientThread clientThread;
    private final SpriteManager spriteManager;
    private final SkillIconManager skillIconManager;
    private final TasksTrackerConfig config;
    private final TriToggleButton completedFilterBtn = new TriToggleButton();
    private final TriToggleButton trackedFilterBtn = new TriToggleButton();
    private final TriToggleButton ignoredFilterBtn = new TriToggleButton();
    private final JPanel titlePanel = new JPanel();
    private final String completeBtnPath = "panel/components/complete_button/style_2a/";
    private final Icon COMPLETE_INCOMPLETE_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/complete_button/style_2a/complete_and_incomplete_icon.png"));
    private final Icon COMPLETE_ONLY_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/complete_button/style_2a/complete_only_icon.png"));
    private final Icon INCOMPLETE_ONLY_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/complete_button/style_2a/incomplete_only_icon.png"));
    private final String ignoredBtnPath = "panel/components/ignored_button/";
    private final Icon VISIBLE_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/ignored_button/visible_icon.png"));
    private final Icon INVISIBLE_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/ignored_button/invisible_icon.png"));
    private final BufferedImage semivisibleimg = ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/ignored_button/semivisible_icon.png");
    private final Icon SEMIVISIBLE_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)this.semivisibleimg, (int)-180));
    private final String trackedBtnPath = "panel/components/tracked_button/";
    private final Icon TRACKED_UNTRACKED_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/tracked_button/tracked_and_untracked_icon.png"));
    private final Icon TRACKED_ONLY_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/tracked_button/tracked_icon.png"));
    private final Icon UNTRACKED_ONLY_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/tracked_button/untracked_icon.png"));
    private final JTabbedPane tabbedPane = new JTabbedPane();
    private SubFilterPanel subFilterPanel;
    private final JToggleButton collapseBtn = new JToggleButton();
    private final String expandBtnPath = "panel/components/";
    private final BufferedImage collapseImg = ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/filter_menu_collapsed.png");
    private final Icon MENU_COLLAPSED_ICON = new ImageIcon(ImageUtil.alphaOffset((Image)this.collapseImg, (int)-180));
    private final Icon MENU_ICON_HOVER = new ImageIcon(this.collapseImg);
    private final Icon MENU_EXPANDED_ICON = new ImageIcon(ImageUtil.loadImageResource(TasksTrackerPlugin.class, (String)"panel/components/filter_menu_expanded.png"));
    private final Map<ConfigValues.TaskListTabs, Map<String, Integer>> filterStore = new HashMap<ConfigValues.TaskListTabs, Map<String, Integer>>();

    public LoggedInPanel(TasksTrackerPlugin plugin, TasksTrackerConfig config, ClientThread clientThread, SpriteManager spriteManager, SkillIconManager skillIconManager) {
        super(false);
        this.plugin = plugin;
        this.clientThread = clientThread;
        this.spriteManager = spriteManager;
        this.skillIconManager = skillIconManager;
        this.config = config;
        this.createPanel(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getParent().getSize();
    }

    public void redraw() {
        this.subFilterPanel.redraw();
        this.updateCollapseButtonText();
        this.taskListPanel.redraw();
    }

    public void refresh(Task task) {
        if (task == null) {
            this.updateCollapseButtonText();
        }
        this.taskListPanel.refresh(task);
    }

    private void createPanel(JPanel parent) {
        parent.setLayout(new BorderLayout());
        parent.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.taskListPanel = new TaskListPanel(this.plugin, this.clientThread, this.spriteManager, this.skillIconManager);
        parent.add((Component)this.getNorthPanel(), "North");
        parent.add((Component)this.getCenterPanel(), "Center");
        parent.add((Component)this.getSouthPanel(), "South");
        this.loadAndApplyFilters(this.config.taskListTab());
        if (this.config.taskListTab().equals((Object)ConfigValues.TaskListTabs.TRACKED)) {
            this.trackedFilterBtn.setState(1);
            this.trackedFilterBtn.setEnabled(false);
            this.plugin.getConfigManager().setConfiguration("tasks-tracker", "trackedFilter", (Object)ConfigValues.TrackedFilterValues.TRACKED);
        }
    }

    private JPanel getCenterPanel() {
        JPanel taskListPanel = new JPanel(new BorderLayout());
        taskListPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        taskListPanel.setBorder(new MatteBorder(0, 0, 1, 0, ColorScheme.MEDIUM_GRAY_COLOR));
        this.tabbedPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.tabbedPane.setPreferredSize(new Dimension(225, 24));
        this.tabbedPane.addTab("Tracked Tasks", this.emptyPanel());
        this.tabbedPane.addTab("All Tasks", this.emptyPanel());
        this.tabbedPane.addTab("Custom", this.emptyPanel());
        taskListPanel.add((Component)this.tabbedPane, "North");
        taskListPanel.add((Component)this.taskListPanel, "Center");
        HashMap<String, Integer> filterStates = new HashMap<String, Integer>();
        filterStates.put("completed", 0);
        filterStates.put("tracked", 0);
        filterStates.put("ignored", 0);
        for (ConfigValues.TaskListTabs tab : ConfigValues.TaskListTabs.values()) {
            this.filterStore.put(tab, filterStates);
        }
        this.tabbedPane.setSelectedIndex(this.config.taskListTab().ordinal());
        this.tabbedPane.addChangeListener(this);
        return taskListPanel;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        ConfigValues.TaskListTabs newTab = ConfigValues.TaskListTabs.values()[this.tabbedPane.getSelectedIndex()];
        this.changeTab(newTab);
        if (newTab.equals((Object)ConfigValues.TaskListTabs.TRACKED)) {
            this.trackedFilterBtn.setState(1);
            this.trackedFilterBtn.setEnabled(false);
            this.plugin.getConfigManager().setConfiguration("tasks-tracker", "taskListTab", (Object)ConfigValues.TaskListTabs.TRACKED);
            this.filterButtonAction("tracked");
        } else {
            this.plugin.getConfigManager().setConfiguration("tasks-tracker", "taskListTab", (Object)newTab);
            this.plugin.refresh();
        }
    }

    private JPanel emptyPanel() {
        JPanel emptyPanel = new JPanel();
        emptyPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        emptyPanel.setPreferredSize(new Dimension(0, 0));
        emptyPanel.setBackground(ColorScheme.MEDIUM_GRAY_COLOR.darker());
        emptyPanel.setVisible(false);
        return emptyPanel;
    }

    private void changeTab(ConfigValues.TaskListTabs newTab) {
        this.saveFilters();
        this.resetFilters();
        this.loadAndApplyFilters(newTab);
    }

    private void saveFilters() {
        ConfigValues.TaskListTabs tab = this.config.taskListTab();
        HashMap<String, Integer> filterStates = new HashMap<String, Integer>();
        filterStates.put("completed", this.config.completedFilter().ordinal());
        filterStates.put("tracked", this.config.trackedFilter().ordinal());
        filterStates.put("ignored", this.config.ignoredFilter().ordinal());
        this.filterStore.put(tab, filterStates);
    }

    private void resetFilters() {
        this.completedFilterBtn.setEnabled(true);
        this.trackedFilterBtn.setEnabled(true);
        this.ignoredFilterBtn.setEnabled(true);
    }

    private void loadAndApplyFilters(ConfigValues.TaskListTabs tab) {
        Map<String, Integer> filterStates = this.filterStore.get((Object)tab);
        if (filterStates == null) {
            return;
        }
        this.completedFilterBtn.setState(filterStates.get("completed"));
        this.trackedFilterBtn.setState(filterStates.get("tracked"));
        this.ignoredFilterBtn.setState(filterStates.get("ignored"));
        Enum configValue = ConfigValues.CompletedFilterValues.values()[this.completedFilterBtn.getState()];
        this.plugin.getConfigManager().setConfiguration("tasks-tracker", "completedFilter", (Object)configValue);
        configValue = ConfigValues.TrackedFilterValues.values()[this.trackedFilterBtn.getState()];
        this.plugin.getConfigManager().setConfiguration("tasks-tracker", "trackedFilter", (Object)configValue);
        configValue = ConfigValues.IgnoredFilterValues.values()[this.ignoredFilterBtn.getState()];
        this.plugin.getConfigManager().setConfiguration("tasks-tracker", "ignoredFilter", (Object)configValue);
    }

    private JPanel getSouthPanel() {
        JPanel southPanel = new JPanel(new BorderLayout());
        southPanel.setBorder(new EmptyBorder(5, 0, 2, 0));
        JButton importButton = new JButton("Import");
        importButton.setBorder(new EmptyBorder(5, 5, 5, 5));
        importButton.setLayout(new BorderLayout(0, 6));
        importButton.addActionListener(e -> this.plugin.openImportJsonDialog());
        southPanel.add((Component)importButton, "West");
        JButton totalsButton = new JButton("Totals");
        totalsButton.setBorder(new EmptyBorder(5, 5, 5, 5));
        totalsButton.setLayout(new BorderLayout(0, 6));
        totalsButton.addActionListener(e -> this.plugin.sendTotalsToChat());
        southPanel.add((Component)totalsButton, "Center");
        JButton exportButton = new JButton("Export");
        exportButton.setBorder(new EmptyBorder(5, 5, 5, 5));
        exportButton.setLayout(new BorderLayout(0, 6));
        exportButton.addActionListener(e -> this.plugin.copyJsonToClipboard(this.plugin.getConfig().taskType()));
        southPanel.add((Component)exportButton, "East");
        return southPanel;
    }

    private JPanel getNorthPanel() {
        JPanel northPanel = new JPanel();
        BoxLayout layout = new BoxLayout(northPanel, 1);
        northPanel.setLayout(layout);
        northPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.taskTypeDropdown = new JComboBox<TaskType>(TaskType.values());
        this.taskTypeDropdown.setAlignmentX(0.0f);
        this.taskTypeDropdown.setSelectedItem((Object)this.plugin.getConfig().taskType());
        this.taskTypeDropdown.addActionListener(e -> this.updateWithNewTaskType(this.taskTypeDropdown.getItemAt(this.taskTypeDropdown.getSelectedIndex())));
        JPanel subFilterWrapper = new JPanel();
        subFilterWrapper.setLayout(new BorderLayout());
        subFilterWrapper.setBorder(new MatteBorder(1, 0, 1, 0, ColorScheme.MEDIUM_GRAY_COLOR));
        subFilterWrapper.setAlignmentX(0.0f);
        subFilterWrapper.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        SwingUtil.removeButtonDecorations((AbstractButton)this.collapseBtn);
        this.collapseBtn.setIcon(this.MENU_COLLAPSED_ICON);
        this.collapseBtn.setSelectedIcon(this.MENU_EXPANDED_ICON);
        this.collapseBtn.setRolloverIcon(this.MENU_ICON_HOVER);
        SwingUtil.addModalTooltip((AbstractButton)this.collapseBtn, (String)"Collapse filters", (String)"Expand filters");
        this.collapseBtn.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        this.collapseBtn.setAlignmentX(0.0f);
        this.collapseBtn.setUI(new BasicButtonUI());
        this.collapseBtn.addActionListener(ev -> this.subFilterPanel.setVisible(!this.subFilterPanel.isVisible()));
        this.collapseBtn.setHorizontalTextPosition(0);
        this.collapseBtn.setForeground(ColorScheme.LIGHT_GRAY_COLOR);
        this.collapseBtn.setFont(FontManager.getRunescapeSmallFont());
        SwingUtil.removeButtonDecorations((AbstractButton)this.collapseBtn);
        this.collapseBtn.setIcon(this.MENU_COLLAPSED_ICON);
        this.collapseBtn.setSelectedIcon(this.MENU_EXPANDED_ICON);
        this.subFilterPanel = new SubFilterPanel(this.plugin, this.spriteManager);
        subFilterWrapper.add((Component)this.collapseBtn, "North");
        subFilterWrapper.add((Component)this.subFilterPanel, "Center");
        northPanel.add(this.getTitleAndButtonPanel());
        northPanel.add(Box.createVerticalStrut(10));
        northPanel.add(this.taskTypeDropdown);
        northPanel.add(Box.createVerticalStrut(2));
        northPanel.add(this.getSearchPanel());
        northPanel.add(Box.createVerticalStrut(5));
        northPanel.add(subFilterWrapper);
        return northPanel;
    }

    private JPanel getTitleAndButtonPanel() {
        this.titlePanel.setLayout(new BorderLayout());
        this.titlePanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.titlePanel.setPreferredSize(new Dimension(0, 30));
        this.titlePanel.setBorder(new EmptyBorder(5, 5, 5, 10));
        JLabel title = new JLabel("Tasks Tracker");
        title.setHorizontalAlignment(2);
        title.setForeground(Color.WHITE);
        JPanel viewControls = new JPanel();
        viewControls.setLayout(new BoxLayout(viewControls, 0));
        viewControls.setBackground(ColorScheme.DARK_GRAY_COLOR);
        SwingUtil.removeButtonDecorations((AbstractButton)this.completedFilterBtn);
        this.completedFilterBtn.setIcons(this.COMPLETE_INCOMPLETE_ICON, this.COMPLETE_ONLY_ICON, this.INCOMPLETE_ONLY_ICON);
        this.completedFilterBtn.setToolTips("All tasks", "Completed tasks only", "Incomplete tasks only");
        this.completedFilterBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.completedFilterBtn.addActionListener(e -> {
            this.completedFilterBtn.changeState();
            this.filterButtonAction("completed");
        });
        this.completedFilterBtn.setState(this.config.completedFilter().ordinal());
        JPopupMenu completedFilterBtnPopupMenu = new JPopupMenu();
        completedFilterBtnPopupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.completedFilterBtn.setComponentPopupMenu(completedFilterBtnPopupMenu);
        JMenuItem allTasksC = new JMenuItem("All tasks");
        allTasksC.addActionListener(e -> {
            this.completedFilterBtn.setState(0);
            this.filterButtonAction("completed");
        });
        completedFilterBtnPopupMenu.add(allTasksC);
        JMenuItem completedTasks = new JMenuItem("Completed tasks only");
        completedTasks.addActionListener(e -> {
            this.completedFilterBtn.setState(1);
            this.filterButtonAction("completed");
        });
        completedFilterBtnPopupMenu.add(completedTasks);
        JMenuItem incompleteTasks = new JMenuItem("Incomplete tasks only");
        incompleteTasks.addActionListener(e -> {
            this.completedFilterBtn.setState(2);
            this.filterButtonAction("completed");
        });
        completedFilterBtnPopupMenu.add(incompleteTasks);
        viewControls.add(this.completedFilterBtn);
        SwingUtil.removeButtonDecorations((AbstractButton)this.trackedFilterBtn);
        this.trackedFilterBtn.setIcons(this.TRACKED_UNTRACKED_ICON, this.TRACKED_ONLY_ICON, this.UNTRACKED_ONLY_ICON);
        this.trackedFilterBtn.setToolTips("All tasks", "Tracked tasks only", "Untracked tasks only");
        this.trackedFilterBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.trackedFilterBtn.addActionListener(e -> {
            this.trackedFilterBtn.changeState();
            this.filterButtonAction("tracked");
        });
        this.trackedFilterBtn.setState(this.config.trackedFilter().ordinal());
        JPopupMenu trackedFilterBtnPopupMenu = new JPopupMenu();
        trackedFilterBtnPopupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.trackedFilterBtn.setComponentPopupMenu(trackedFilterBtnPopupMenu);
        JMenuItem allTasksT = new JMenuItem("All tasks");
        allTasksT.addActionListener(e -> {
            this.trackedFilterBtn.setState(0);
            this.filterButtonAction("tracked");
        });
        trackedFilterBtnPopupMenu.add(allTasksT);
        JMenuItem trackedTasks = new JMenuItem("Tracked tasks only");
        trackedTasks.addActionListener(e -> {
            this.trackedFilterBtn.setState(1);
            this.filterButtonAction("tracked");
        });
        trackedFilterBtnPopupMenu.add(trackedTasks);
        JMenuItem untrackedTasks = new JMenuItem("Untracked tasks only");
        untrackedTasks.addActionListener(e -> {
            this.trackedFilterBtn.setState(2);
            this.filterButtonAction("tracked");
        });
        trackedFilterBtnPopupMenu.add(untrackedTasks);
        viewControls.add(this.trackedFilterBtn);
        SwingUtil.removeButtonDecorations((AbstractButton)this.ignoredFilterBtn);
        this.ignoredFilterBtn.setIcons(this.SEMIVISIBLE_ICON, this.VISIBLE_ICON, this.INVISIBLE_ICON);
        this.ignoredFilterBtn.setToolTips("Hide ignored tasks", "All tasks", "Ignored tasks only");
        this.ignoredFilterBtn.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.ignoredFilterBtn.addActionListener(e -> {
            this.ignoredFilterBtn.changeState();
            this.filterButtonAction("ignored");
        });
        this.ignoredFilterBtn.setState(this.config.ignoredFilter().ordinal());
        JPopupMenu ignoredFilterBtnPopupMenu = new JPopupMenu();
        ignoredFilterBtnPopupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.ignoredFilterBtn.setComponentPopupMenu(ignoredFilterBtnPopupMenu);
        JMenuItem allTasksI = new JMenuItem("All tasks");
        allTasksI.addActionListener(e -> {
            this.ignoredFilterBtn.setState(1);
            this.filterButtonAction("ignored");
        });
        ignoredFilterBtnPopupMenu.add(allTasksI);
        JMenuItem unignoredTasks = new JMenuItem("Hide ignored tasks");
        unignoredTasks.addActionListener(e -> {
            this.ignoredFilterBtn.setState(0);
            this.filterButtonAction("ignored");
        });
        ignoredFilterBtnPopupMenu.add(unignoredTasks);
        JMenuItem ignoredTasks = new JMenuItem("Ignored tasks only");
        ignoredTasks.addActionListener(e -> {
            this.ignoredFilterBtn.setState(2);
            this.filterButtonAction("ignored");
        });
        ignoredFilterBtnPopupMenu.add(ignoredTasks);
        viewControls.add(this.ignoredFilterBtn);
        this.titlePanel.add((Component)viewControls, "East");
        this.titlePanel.add((Component)title, "West");
        this.titlePanel.setAlignmentX(0.0f);
        return this.titlePanel;
    }

    private void filterButtonAction(String filter) {
        Enum configValue;
        switch (filter) {
            case "completed": {
                int state = this.completedFilterBtn.getState();
                configValue = ConfigValues.CompletedFilterValues.values()[state];
                break;
            }
            case "tracked": {
                int state = this.trackedFilterBtn.getState();
                configValue = ConfigValues.TrackedFilterValues.values()[state];
                break;
            }
            case "ignored": {
                int state = this.ignoredFilterBtn.getState();
                configValue = ConfigValues.IgnoredFilterValues.values()[state];
                break;
            }
            default: {
                log.debug("Filter button action failed due to unrecognised filter.");
                return;
            }
        }
        this.plugin.getConfigManager().setConfiguration("tasks-tracker", filter + "Filter", (Object)configValue);
        this.plugin.refresh();
    }

    private JPanel getSearchPanel() {
        JPanel filtersPanel = new JPanel();
        filtersPanel.setAlignmentX(0.0f);
        filtersPanel.setLayout(new BoxLayout(filtersPanel, 1));
        SearchBox textSearch = new SearchBox();
        textSearch.addTextChangedListener(() -> {
            this.plugin.taskTextFilter = textSearch.getText().toLowerCase();
            this.plugin.refresh();
        });
        filtersPanel.add((Component)((Object)textSearch));
        return filtersPanel;
    }

    private void updateWithNewTaskType(TaskType taskType) {
        this.plugin.getConfigManager().setConfiguration("tasks-tracker", "taskType", (Object)taskType);
        this.redraw();
        this.refresh(null);
    }

    private void updateCollapseButtonText() {
        int count;
        if (this.plugin.getConfig().taskType() == null) {
            return;
        }
        ArrayList<CallSite> filterCounts = new ArrayList<CallSite>();
        if (this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_3) || this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_4)) {
            count = this.config.skillFilter().equals("") ? 0 : this.config.skillFilter().split(",").length;
            filterCounts.add((CallSite)((Object)(count + " skill")));
        }
        if (this.plugin.getConfig().taskType().equals((Object)TaskType.LEAGUE_4)) {
            count = this.config.areaFilter().equals("") ? 0 : this.config.areaFilter().split(",").length;
            filterCounts.add((CallSite)((Object)(count + " area")));
        }
        count = this.config.tierFilter().equals("") ? 0 : this.config.tierFilter().split(",").length;
        filterCounts.add((CallSite)((Object)(count + " tier")));
        this.collapseBtn.setText(String.join((CharSequence)", ", filterCounts) + " filters");
    }
}

