/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.data;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.reldo.taskstracker.data.LongSerializer;
import net.reldo.taskstracker.tasktypes.Task;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.runelite.client.config.ConfigManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerDataStore {
    private static final Logger log = LoggerFactory.getLogger(TrackerDataStore.class);
    public static final String CONFIG_TASKS_PREFIX = "tasks";
    public static final String CONFIG_GROUP_PREFIX_SEPARATOR = "-";
    public static final String CONFIG_GROUP_NAME = "tasks-tracker";
    private Gson gson;
    private final ConfigManager configManager;

    @Inject
    public TrackerDataStore(ConfigManager configManager, Gson gson) {
        this.configManager = configManager;
        this.gson = gson.newBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(Float.TYPE, (Object)new LongSerializer()).create();
    }

    public HashMap<Integer, Task> loadTaskTypeFromConfig(TaskType taskType) {
        log.debug("loadTaskTypeFromConfig {}", (Object)taskType.getDisplayString());
        String key = "tasks-" + taskType.name();
        String jsonString = this.configManager.getRSProfileConfiguration(CONFIG_GROUP_NAME, key);
        if (jsonString == null) {
            log.debug("No save information for task type {}, returning empty", (Object)taskType.getDisplayString());
            return new HashMap<Integer, Task>();
        }
        Type taskClassType = taskType.getClassType();
        Type deserializeType = TypeToken.getParameterized(HashMap.class, (Type[])new Type[]{Integer.class, taskClassType}).getType();
        try {
            return (HashMap)this.gson.fromJson(jsonString, deserializeType);
        }
        catch (JsonParseException ex) {
            log.error("{} {} json invalid. All is lost", new Object[]{CONFIG_GROUP_NAME, key, ex});
            this.configManager.unsetRSProfileConfiguration(CONFIG_GROUP_NAME, key);
            return new HashMap<Integer, Task>();
        }
    }

    public void saveTaskTypeToConfig(TaskType taskType, Collection<Task> tasks) {
        log.debug("saveTaskTypeToConfig");
        Map<Integer, Task> tasksWithData = tasks.stream().filter(task -> task.getCompletedOn() != 0L || task.getIgnoredOn() != 0L || task.getTrackedOn() != 0L).collect(Collectors.toMap(Task::getId, task -> task));
        String configValue = this.gson.toJson(tasksWithData);
        this.configManager.setRSProfileConfiguration(CONFIG_GROUP_NAME, "tasks-" + taskType.name(), (Object)configValue);
    }
}

