/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.data;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.reldo.taskstracker.data.CallbackCommand;
import net.reldo.taskstracker.tasktypes.Task;
import net.reldo.taskstracker.tasktypes.TaskType;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TaskDataClient {
    private static final Logger log = LoggerFactory.getLogger(TaskDataClient.class);
    @Inject
    private OkHttpClient okHttpClient;
    @Inject
    private Gson gson;
    private static final String BASE_URL = "https://raw.githubusercontent.com/osrs-reldo/task-json-store/main/";
    private static final String JSON_MIN_PATH = "https://raw.githubusercontent.com/osrs-reldo/task-json-store/main/json/min/";

    public void loadTaskSourceData(TaskType taskType, CallbackCommand<ArrayList<Task>> callback) {
        Type classType = taskType.getClassType();
        Type listType = TypeToken.getParameterized(ArrayList.class, (Type[])new Type[]{classType}).getType();
        this.getTaskJson(taskType.getDataFileName(), jsonResponse -> {
            ArrayList result = (ArrayList)this.gson.fromJson((Reader)new InputStreamReader((InputStream)jsonResponse, StandardCharsets.UTF_8), listType);
            callback.execute(result);
        });
    }

    private void getTaskJson(final String jsonName, final CallbackCommand<InputStream> command) {
        try {
            String url = JSON_MIN_PATH + jsonName;
            log.debug("Fetching task json {} from {}...", (Object)jsonName, (Object)url);
            Request request = new Request.Builder().url(url).build();
            this.okHttpClient.newCall(request).enqueue(new Callback(){

                public void onFailure(@NonNull Call call, @NonNull IOException e) {
                    if (call == null) {
                        throw new NullPointerException("call is marked non-null but is null");
                    }
                    if (e == null) {
                        throw new NullPointerException("e is marked non-null but is null");
                    }
                    log.error("Error retrieving task json {}", (Object)jsonName, (Object)e);
                }

                public void onResponse(@NonNull Call call, @NonNull Response response) {
                    if (call == null) {
                        throw new NullPointerException("call is marked non-null but is null");
                    }
                    if (response == null) {
                        throw new NullPointerException("response is marked non-null but is null");
                    }
                    if (response.isSuccessful()) {
                        if (response.body() == null) {
                            log.error("Task json request returned no body");
                            response.close();
                            return;
                        }
                        log.debug("Task json {} fetched successfully, executing callback", (Object)jsonName);
                        command.execute(response.body().byteStream());
                    } else {
                        String unsuccessful = "Task json request unsuccessful with status {}" + response.code();
                        if (response.body() != null) {
                            unsuccessful = unsuccessful + " and body \n" + response.body();
                        }
                        log.error(unsuccessful);
                    }
                    response.close();
                }
            });
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to get task json: {}", (Object)e.getLocalizedMessage());
        }
    }
}

