/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker.data;

import com.google.gson.annotations.Expose;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import net.reldo.taskstracker.bosses.BossData;
import net.reldo.taskstracker.quests.DiaryData;
import net.reldo.taskstracker.quests.QuestData;
import net.reldo.taskstracker.tasktypes.Task;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.reldo.taskstracker.tasktypes.league3.League3TaskVarps;
import net.reldo.taskstracker.tasktypes.league3.League3Varbits;
import net.reldo.taskstracker.tasktypes.league3.League3Varps;
import net.reldo.taskstracker.tasktypes.league4.League4Varbits;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.plugins.PluginManager;

public class Export {
    private final Client client;
    @Expose
    private final QuestData quests;
    @Expose
    private final DiaryData diaries;
    @Expose
    private final BossData bosses;
    @Expose
    private String displayName;
    @Expose
    private final int runescapeVersion;
    @Expose
    private final String runeliteVersion;
    @Expose
    private final long timestamp;
    @Expose
    private final String taskType;
    @Expose
    private final HashMap<Integer, Integer> varbits;
    @Expose
    private final HashMap<Integer, Integer> varps;
    @Expose
    private HashMap<String, Task> tasks;

    public Export(TaskType taskType, String runeliteVersion, Client client, PluginManager pluginManager, ConfigManager configManager) {
        this.client = client;
        Player localPlayer = client.getLocalPlayer();
        if (localPlayer != null) {
            this.displayName = localPlayer.getName();
        }
        this.quests = new QuestData(client);
        this.diaries = new DiaryData(client);
        this.bosses = new BossData(pluginManager, configManager);
        this.runescapeVersion = client.getRevision();
        this.runeliteVersion = runeliteVersion;
        this.timestamp = Instant.now().toEpochMilli();
        this.taskType = taskType.name();
        this.varbits = this.getVarbits(taskType);
        this.varps = this.getVarps(taskType);
    }

    private HashMap<Integer, Integer> getVarbits(TaskType taskType) {
        assert (this.client.isClientThread());
        List<Integer> varbitIds = null;
        if (taskType == TaskType.LEAGUE_3) {
            varbitIds = League3Varbits.getAllVarbitIds();
        }
        if (taskType == TaskType.LEAGUE_4) {
            varbitIds = League4Varbits.getAllVarbitIds();
        }
        if (varbitIds == null) {
            return null;
        }
        HashMap<Integer, Integer> varbitValueMap = new HashMap<Integer, Integer>();
        for (int varbitId : varbitIds) {
            varbitValueMap.put(varbitId, this.client.getVarbitValue(varbitId));
        }
        return varbitValueMap;
    }

    public HashMap<Integer, Integer> getVarps(TaskType taskType) {
        assert (this.client.isClientThread());
        List<Integer> varpIds = null;
        if (taskType == TaskType.LEAGUE_3) {
            varpIds = League3Varps.getAllVarpIds();
            varpIds.addAll(League3TaskVarps.getAllVarpIds());
        }
        if (taskType == TaskType.COMBAT) {
            varpIds = League3Varps.getAllVarpIds();
        }
        if (varpIds == null) {
            return null;
        }
        HashMap<Integer, Integer> varpValueMap = new HashMap<Integer, Integer>();
        for (int varpId : varpIds) {
            varpValueMap.put(varpId, this.client.getVarpValue(varpId));
        }
        return varpValueMap;
    }

    public Client getClient() {
        return this.client;
    }

    public QuestData getQuests() {
        return this.quests;
    }

    public DiaryData getDiaries() {
        return this.diaries;
    }

    public BossData getBosses() {
        return this.bosses;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getRunescapeVersion() {
        return this.runescapeVersion;
    }

    public String getRuneliteVersion() {
        return this.runeliteVersion;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public HashMap<Integer, Integer> getVarbits() {
        return this.varbits;
    }

    public HashMap<Integer, Integer> getVarps() {
        return this.varps;
    }

    public HashMap<String, Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(HashMap<String, Task> tasks) {
        this.tasks = tasks;
    }
}

