/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker;

import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.reldo.taskstracker.TasksTrackerConfig;
import net.reldo.taskstracker.data.CallbackCommand;
import net.reldo.taskstracker.data.Export;
import net.reldo.taskstracker.data.LongSerializer;
import net.reldo.taskstracker.data.TaskDataClient;
import net.reldo.taskstracker.data.TrackerDataStore;
import net.reldo.taskstracker.data.reldo.ReldoImport;
import net.reldo.taskstracker.data.reldo.ReldoTaskSave;
import net.reldo.taskstracker.panel.TasksTrackerPluginPanel;
import net.reldo.taskstracker.tasktypes.Task;
import net.reldo.taskstracker.tasktypes.TaskManager;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.reldo.taskstracker.tasktypes.TasksSummary;
import net.reldo.taskstracker.tasktypes.combattask.CombatTaskVarps;
import net.reldo.taskstracker.tasktypes.league3.League3TaskVarps;
import net.reldo.taskstracker.tasktypes.league4.League4TaskVarps;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.config.RuneScapeProfileType;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.game.SpriteManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.LinkBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Tasks Tracker")
public class TasksTrackerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TasksTrackerPlugin.class);
    public static final String CONFIG_GROUP_NAME = "tasks-tracker";
    public int[] playerSkills;
    public HashMap<TaskType, TaskManager> taskManagers = new HashMap();
    public String taskTextFilter;
    public TasksTrackerPluginPanel pluginPanel;
    private static final long VARP_UPDATE_THROTTLE_DELAY_MS = 7000L;
    private boolean forceUpdateVarpsFlag = false;
    private Set<Integer> varpIdsToUpdate = new HashSet<Integer>();
    private long lastVarpUpdate = 0L;
    private NavigationButton navButton;
    private RuneScapeProfileType currentProfileType;
    @Inject
    @Named(value="runelite.version")
    private String runeliteVersion;
    @Inject
    private Gson gson;
    @Inject
    private Client client;
    @Inject
    private SpriteManager spriteManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private SkillIconManager skillIconManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private TasksTrackerConfig config;
    @Inject
    private TaskDataClient taskDataClient;
    @Inject
    private TrackerDataStore trackerDataStore;

    @Provides
    TasksTrackerConfig getConfig(ConfigManager configManager) {
        return (TasksTrackerConfig)configManager.getConfig(TasksTrackerConfig.class);
    }

    protected void startUp() {
        this.forceUpdateVarpsFlag = false;
        this.pluginPanel = new TasksTrackerPluginPanel(this, this.config, this.clientThread, this.spriteManager, this.skillIconManager);
        boolean isLoggedIn = this.isLoggedInState(this.client.getGameState());
        this.pluginPanel.setLoggedIn(isLoggedIn);
        for (TaskType taskType : TaskType.values()) {
            TaskManager taskManager = new TaskManager(taskType, this.taskDataClient);
            this.taskManagers.put(taskType, taskManager);
            taskManager.asyncLoadTaskSourceData(tasks -> {
                if (isLoggedIn && taskType == this.config.taskType()) {
                    this.forceUpdateVarpsFlag = true;
                }
            });
        }
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"panel_icon.png");
        this.navButton = NavigationButton.builder().tooltip("Task Tracker").icon(icon).priority(5).panel((PluginPanel)this.pluginPanel).build();
        this.clientToolbar.addNavigation(this.navButton);
        log.info("Tasks Tracker started!");
    }

    protected void shutDown() {
        this.pluginPanel = null;
        this.taskManagers = new HashMap();
        this.clientToolbar.removeNavigation(this.navButton);
        log.info("Tasks Tracker stopped!");
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged varbitChanged) {
        if (this.forceUpdateVarpsFlag) {
            return;
        }
        this.varpIdsToUpdate.add(varbitChanged.getVarpId());
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (!configChanged.getGroup().equals(CONFIG_GROUP_NAME)) {
            return;
        }
        log.debug("onConfigChanged {} {}", (Object)configChanged.getKey(), (Object)configChanged.getNewValue());
        if (configChanged.getKey().equals("untrackUponCompletion") && this.config.untrackUponCompletion()) {
            this.forceVarpUpdate();
        }
        if (configChanged.getKey().equals("filterPanelCollapsible")) {
            this.pluginPanel.redraw();
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        log.debug("onGameStateChanged {}", (Object)gameStateChanged.getGameState().toString());
        GameState newGameState = gameStateChanged.getGameState();
        RuneScapeProfileType newProfileType = RuneScapeProfileType.getCurrent((Client)this.client);
        SwingUtilities.invokeLater(() -> this.pluginPanel.setLoggedIn(this.isLoggedInState(newGameState)));
        if (newGameState == GameState.LOGGING_IN) {
            this.forceUpdateVarpsFlag = true;
        }
        if (this.isLoggedInState(newGameState) && this.currentProfileType != null && this.currentProfileType != newProfileType) {
            this.forceUpdateVarpsFlag = true;
        }
        this.currentProfileType = newProfileType;
    }

    private boolean isLoggedInState(GameState gameState) {
        return gameState == GameState.LOGGED_IN || gameState == GameState.HOPPING || gameState == GameState.LOADING;
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        int[] newSkills;
        boolean changed;
        long currentTimeEpoch;
        if (this.forceUpdateVarpsFlag) {
            log.debug("loginFlag game tick");
            this.loadSavedTaskTypeData(this.config.taskType());
            this.forceVarpUpdate();
            SwingUtilities.invokeLater(() -> this.pluginPanel.redraw());
            this.forceUpdateVarpsFlag = false;
        }
        if ((currentTimeEpoch = System.currentTimeMillis()) - this.lastVarpUpdate > 7000L) {
            this.flushVarpUpdates(this.varpIdsToUpdate);
            this.varpIdsToUpdate = new HashSet<Integer>();
            this.lastVarpUpdate = currentTimeEpoch;
        }
        boolean bl = changed = !Arrays.equals(this.playerSkills, newSkills = this.client.getRealSkillLevels());
        if (changed) {
            this.playerSkills = this.client.getRealSkillLevels();
            SwingUtilities.invokeLater(() -> this.pluginPanel.refresh(null));
        }
    }

    public void refresh() {
        this.pluginPanel.refresh(null);
    }

    public void saveCurrentTaskData() {
        log.debug("saveCurrentTaskData");
        this.trackerDataStore.saveTaskTypeToConfig(this.config.taskType(), this.taskManagers.get((Object)((Object)this.config.taskType())).tasks.values());
    }

    public void openImportJsonDialog() {
        ReldoImport reldoImport;
        JOptionPane optionPane = new JOptionPane("Paste import data into the text field below to import task tracker data.", 1);
        optionPane.setWantsInput(true);
        JDialog inputDialog = optionPane.createDialog((Component)((Object)this.pluginPanel), "Import Tasks Input");
        inputDialog.setAlwaysOnTop(true);
        inputDialog.setVisible(true);
        if (optionPane.getInputValue().equals("") || optionPane.getInputValue().equals("uninitializedValue")) {
            this.showMessageBox("Import Tasks Error", "Input was empty so no data has been imported.", 0, false);
            return;
        }
        String json = "";
        try {
            json = (String)optionPane.getInputValue();
            reldoImport = (ReldoImport)this.gson.fromJson(json, ReldoImport.class);
        }
        catch (Exception ex) {
            this.showMessageBox("Import Tasks Error", "There was an issue importing task tracker data. " + ex.getMessage(), 0, false);
            log.error("There was an issue importing task tracker data.", (Throwable)ex);
            log.debug("reldoImport json: {}", (Object)json);
            return;
        }
        optionPane = new JOptionPane("Importing tasks will overwrite task tracker settings and cannot be undone. Are you sure you want to import tasks?", 2, 0);
        JDialog confirmDialog = optionPane.createDialog((Component)((Object)this.pluginPanel), "Import Tasks Overwrite Confirmation");
        confirmDialog.setAlwaysOnTop(true);
        confirmDialog.setVisible(true);
        Object selectedValue = optionPane.getValue();
        if (selectedValue == null) {
            return;
        }
        if (selectedValue.equals(0)) {
            reldoImport.getTasks().forEach((id, reldoTaskSave) -> {
                Task task = this.taskManagers.get((Object)((Object)((Object)TaskType.LEAGUE_4))).tasks.get(id);
                task.loadReldoSave((ReldoTaskSave)reldoTaskSave);
            });
            this.trackerDataStore.saveTaskTypeToConfig(TaskType.LEAGUE_4, this.taskManagers.get((Object)((Object)TaskType.LEAGUE_4)).tasks.values());
            this.pluginPanel.redraw();
        }
    }

    public void sendTotalsToChat() {
        TasksSummary summary = this.taskManagers.get((Object)this.config.taskType()).getSummary();
        int trackedTasks = summary.trackedTasksCount;
        int trackedPoints = summary.trackedTasksPoints;
        String message = new ChatMessageBuilder().append(Color.BLACK, String.format("Task Tracker - Tracked Tasks: %s | Tracked Points: %s", trackedTasks, trackedPoints)).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    public void copyJsonToClipboard(TaskType taskType) {
        this.clientThread.invokeLater(() -> {
            String exportJson = this.exportToJson(taskType);
            StringSelection stringSelection = new StringSelection(exportJson);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            String message = "Exported " + taskType.getDisplayString() + " data copied to clipboard!";
            this.showMessageBox("Data Exported!", message, 1, true);
        });
    }

    private void loadSavedTaskTypeData(TaskType taskType) {
        log.debug("loadSavedTaskTypeData {}", (Object)taskType.name());
        HashMap<Integer, Task> taskData = this.trackerDataStore.loadTaskTypeFromConfig(taskType);
        this.taskManagers.get((Object)taskType).applyTrackerSave(taskData);
        this.trackerDataStore.saveTaskTypeToConfig(taskType, this.taskManagers.get((Object)((Object)taskType)).tasks.values());
    }

    private void forceVarpUpdate() {
        log.debug("forceVarpUpdate");
        ArrayList<Integer> allVarbitIds = new ArrayList<Integer>();
        allVarbitIds.addAll(League4TaskVarps.getIdToVarpMap().keySet());
        allVarbitIds.addAll(CombatTaskVarps.getIdToVarpMap().keySet());
        allVarbitIds.forEach(id -> this.processVarpAndUpdateTasks((int)id, processed -> {
            if (processed.booleanValue()) {
                this.saveCurrentTaskData();
            }
        }));
    }

    private void flushVarpUpdates(Set<Integer> varpIds) {
        log.debug("Flushing throttled varp updates {}", varpIds);
        varpIds.forEach(id -> this.processVarpAndUpdateTasks((int)id, processed -> {
            if (processed.booleanValue()) {
                this.saveCurrentTaskData();
            }
        }));
    }

    private void processVarpAndUpdateTasks(int varpId, CallbackCommand<Boolean> resultCallback) {
        CombatTaskVarps combatTaskVarp;
        League4TaskVarps league4Varp;
        int ordinal = -1;
        TaskType taskType = null;
        League3TaskVarps league3Varp = League3TaskVarps.getIdToVarpMap().get(varpId);
        if (league3Varp != null) {
            ordinal = league3Varp.ordinal();
            taskType = TaskType.LEAGUE_3;
        }
        if ((league4Varp = League4TaskVarps.getIdToVarpMap().get(varpId)) != null) {
            ordinal = league4Varp.ordinal();
            taskType = TaskType.LEAGUE_4;
        }
        if ((combatTaskVarp = CombatTaskVarps.getIdToVarpMap().get(varpId)) != null) {
            ordinal = combatTaskVarp.ordinal();
            taskType = TaskType.COMBAT;
        }
        if (taskType == null) {
            resultCallback.execute(false);
            return;
        }
        HashMap completionById = new HashMap();
        int finalOrdinal = ordinal;
        TaskType finalTaskType = taskType;
        this.clientThread.invokeLater(() -> {
            BigInteger varpValue = BigInteger.valueOf(this.client.getVarpValue(varpId));
            log.debug("processVarpAndUpdateTasks {} {}", (Object)varpId, (Object)varpValue);
            int minTaskId = finalOrdinal * 32;
            int maxTaskId = minTaskId + 31;
            for (int i = minTaskId; i <= maxTaskId; ++i) {
                boolean isTaskVarbitCompleted;
                int bitIndex = i % 32;
                try {
                    isTaskVarbitCompleted = varpValue.testBit(bitIndex);
                }
                catch (IllegalArgumentException ex) {
                    log.error("Bit test failed {} {}", new Object[]{varpId, bitIndex, ex});
                    isTaskVarbitCompleted = false;
                }
                completionById.put(i, isTaskVarbitCompleted);
            }
            for (Map.Entry taskCompletion : completionById.entrySet()) {
                int id = (Integer)taskCompletion.getKey();
                boolean completed = (Boolean)taskCompletion.getValue();
                Task task = this.taskManagers.get((Object)((Object)((Object)finalTaskType))).tasks.get(id);
                if (task == null) continue;
                task.setCompleted(completed);
                if (completed && this.config.untrackUponCompletion()) {
                    task.setTracked(false);
                }
                SwingUtilities.invokeLater(() -> this.pluginPanel.refresh(task));
            }
            resultCallback.execute(true);
        });
    }

    private String exportToJson(TaskType taskType) {
        Gson gson = this.gson.newBuilder().excludeFieldsWithoutExposeAnnotation().registerTypeAdapter(Float.TYPE, (Object)new LongSerializer()).create();
        if (taskType == null) {
            return gson.toJson(this.taskManagers);
        }
        Export export = new Export(taskType, this.runeliteVersion, this.client, this.pluginManager, this.configManager);
        HashMap<String, Task> tasksById = new HashMap<String, Task>();
        this.taskManagers.get((Object)((Object)taskType)).tasks.values().forEach(task -> tasksById.put(String.valueOf(task.getId()), (Task)task));
        export.setTasks(tasksById);
        return gson.toJson((Object)export);
    }

    private void showMessageBox(String title, String message, int messageType, boolean showOpenLeagueTools) {
        SwingUtilities.invokeLater(() -> {
            JOptionPane optionPane;
            if (showOpenLeagueTools) {
                Object[] options = new String[]{"Open OS League Tools", "Ok"};
                optionPane = new JOptionPane(message, messageType, 0, null, options, options[1]);
            } else {
                optionPane = new JOptionPane(message, messageType);
            }
            JDialog dialog = optionPane.createDialog((Component)((Object)this.pluginPanel), title);
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
            Object selectedValue = optionPane.getValue();
            if (selectedValue == null) {
                return;
            }
            if (selectedValue.equals("Open OS League Tools")) {
                LinkBrowser.browse((String)"https://www.osleague.tools/tracker?open=import&tab=tasks");
            }
        });
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public TasksTrackerConfig getConfig() {
        return this.config;
    }
}

