/*
 * Decompiled with CFR 0.152.
 */
package net.reldo.taskstracker;

import net.reldo.taskstracker.config.ConfigValues;
import net.reldo.taskstracker.tasktypes.TaskType;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;

@ConfigGroup(value="tasks-tracker")
public interface TasksTrackerConfig
extends Config {
    @ConfigItem(position=10, keyName="untrackUponCompletion", name="Untrack Tasks Upon Completion", description="Configures whether completed tasks should also automatically untracked when the task is completed.")
    default public boolean untrackUponCompletion() {
        return false;
    }

    @ConfigItem(position=11, keyName="filterPanelCollapsible", name="Filter Panels Collapsible", description="Shows button that allows filter panels to be hidden.")
    default public boolean filterPanelCollapsible() {
        return true;
    }

    @ConfigItem(position=12, keyName="saveAreaFilterState", name="Save Area Filter State", description="Configures whether the state of area filters should be saved and recalled when switching task type or restarting the plugin.")
    default public boolean saveAreaFilterState() {
        return true;
    }

    @ConfigItem(position=100, keyName="completedFilter", name="Completed Tasks Filter", description="Configures whether completed tasks should be displayed.", hidden=true)
    default public ConfigValues.CompletedFilterValues completedFilter() {
        return ConfigValues.CompletedFilterValues.COMPLETE_AND_INCOMPLETE;
    }

    @ConfigItem(position=101, keyName="trackedFilter", name="Tracked Tasks Filter", description="Configures whether tracked tasks should be displayed.", hidden=true)
    default public ConfigValues.TrackedFilterValues trackedFilter() {
        return ConfigValues.TrackedFilterValues.TRACKED_AND_UNTRACKED;
    }

    @ConfigItem(position=102, keyName="ignoredFilter", name="Ignored Tasks Filter", description="Configures whether ignored tasks should be displayed.", hidden=true)
    default public ConfigValues.IgnoredFilterValues ignoredFilter() {
        return ConfigValues.IgnoredFilterValues.NOT_IGNORED;
    }

    @ConfigItem(position=103, keyName="taskListTab", name="Selected Task List Tab", description="Configures the currently selected tab on the task list.", hidden=true)
    default public ConfigValues.TaskListTabs taskListTab() {
        return ConfigValues.TaskListTabs.ALL;
    }

    @ConfigItem(position=104, keyName="skillFilter", name="Skills Filter", description="Configures the skills to filter tasks on.", hidden=true)
    default public String skillFilter() {
        return "";
    }

    @ConfigItem(position=105, keyName="tierFilter", name="Tier Filter", description="Configures the tiers to filter tasks on.", hidden=true)
    default public String tierFilter() {
        return "";
    }

    @ConfigItem(position=106, keyName="taskType", name="Task Type", description="Configures the task type which is displayed in the panel.", hidden=true)
    default public TaskType taskType() {
        return TaskType.COMBAT;
    }

    @ConfigItem(position=107, keyName="areaFilter", name="Area Filter", description="Configures the areas to filter tasks on.", hidden=true)
    default public String areaFilter() {
        return "";
    }

    @ConfigItem(position=108, keyName="categoryFilter", name="Category Filter", description="Configures the category to filter tasks on.", hidden=true)
    default public String categoryFilter() {
        return "";
    }
}

