/*
 * Decompiled with CFR 0.152.
 */
package com.stopmisclickingtiles;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import com.stopmisclickingtiles.DisabledTile;
import com.stopmisclickingtiles.MovementFlag;
import com.stopmisclickingtiles.StopMisclickingTilesConfig;
import com.stopmisclickingtiles.TileOverlay;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="StopMisclickingTiles", description="Shift + Right-click a tile to disable the \"walk here\" action on it.")
public class StopMisclickingTilesPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(StopMisclickingTilesPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private TileOverlay overlay;
    @Inject
    private StopMisclickingTilesConfig config;
    @Inject
    private Gson gson;
    private final List<WorldPoint> disabledPoints = new ArrayList<WorldPoint>();
    private static final String CONFIG_GROUP = "smt";
    private static final String REGION_PREFIX = "region_";

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.loadTiles();
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.disabledPoints.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        this.loadTiles();
    }

    void saveTiles(int regionId, Collection<DisabledTile> tiles) {
        if (tiles == null || tiles.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
            return;
        }
        String json = this.gson.toJson(tiles);
        this.configManager.setConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId, json);
    }

    Collection<DisabledTile> getDisabledTiles(int regionId) {
        String json = this.configManager.getConfiguration(CONFIG_GROUP, REGION_PREFIX + regionId);
        if (Strings.isNullOrEmpty((String)json)) {
            return Collections.emptyList();
        }
        return (Collection)this.gson.fromJson(json, new TypeToken<List<DisabledTile>>(){}.getType());
    }

    void loadTiles() {
        this.disabledPoints.clear();
        int[] regions = this.client.getMapRegions();
        if (regions == null) {
            return;
        }
        for (int regionId : regions) {
            log.debug("Loading points for region {}", (Object)regionId);
            Collection<DisabledTile> regionTiles = this.getDisabledTiles(regionId);
            Collection<WorldPoint> points = this.translateToWorldPoint(regionTiles);
            this.disabledPoints.addAll(points);
        }
    }

    private Collection<WorldPoint> translateToWorldPoint(Collection<DisabledTile> tiles) {
        if (tiles.isEmpty()) {
            return Collections.emptyList();
        }
        return tiles.stream().map(tile -> WorldPoint.fromRegion((int)tile.getRegionId(), (int)tile.getRegionX(), (int)tile.getRegionY(), (int)tile.getZ())).flatMap(wp -> {
            Collection localWorldPoints = WorldPoint.toLocalInstance((Client)this.client, (WorldPoint)wp);
            return localWorldPoints.stream();
        }).collect(Collectors.toList());
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuOption().equalsIgnoreCase("Walk here")) {
            Tile tile = this.client.getSelectedSceneTile();
            if (tile == null) {
                return;
            }
            WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)tile.getLocalLocation());
            int regionId = worldPoint.getRegionID();
            DisabledTile dTile = new DisabledTile(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), worldPoint.getPlane());
            if (this.getDisabledTiles(regionId).contains(dTile)) {
                event.consume();
                return;
            }
            if (this.client.getCollisionMaps() == null) {
                return;
            }
            int[][] flags = this.client.getCollisionMaps()[this.client.getPlane()].getFlags();
            int data = flags[tile.getSceneLocation().getX()][tile.getSceneLocation().getY()];
            Set<MovementFlag> movementFlags = MovementFlag.getSetFlags(data);
            if (this.config.disableTilesBlockedByObject() && movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_OBJECT)) {
                event.consume();
            } else if (this.config.disableOtherBlockedTiles() && movementFlags.contains((Object)MovementFlag.BLOCK_MOVEMENT_FLOOR)) {
                event.consume();
            }
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        boolean hotKeyPressed = this.client.isKeyPressed(81);
        if (hotKeyPressed && event.getOption().equals("Walk here")) {
            Tile selectedSceneTile = this.client.getSelectedSceneTile();
            if (selectedSceneTile == null) {
                return;
            }
            WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)selectedSceneTile.getLocalLocation());
            int regionId = worldPoint.getRegionID();
            DisabledTile dTile = new DisabledTile(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), worldPoint.getPlane());
            boolean exists = this.getDisabledTiles(regionId).contains(dTile);
            this.client.createMenuEntry(-1).setOption(exists ? "Enable Walk here" : "Disable Walk here").setTarget(event.getTarget()).setType(MenuAction.RUNELITE).onClick(e -> {
                Tile target = this.client.getSelectedSceneTile();
                if (target != null) {
                    this.toggleTile(target);
                }
            });
        }
    }

    private void toggleTile(Tile tile) {
        if (tile == null) {
            return;
        }
        WorldPoint worldPoint = WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)tile.getLocalLocation());
        int regionId = worldPoint.getRegionID();
        DisabledTile dTile = new DisabledTile(regionId, worldPoint.getRegionX(), worldPoint.getRegionY(), worldPoint.getPlane());
        ArrayList<DisabledTile> tiles = new ArrayList<DisabledTile>(this.getDisabledTiles(regionId));
        if (tiles.contains(dTile)) {
            tiles.remove(dTile);
        } else {
            tiles.add(dTile);
        }
        this.saveTiles(regionId, tiles);
        this.loadTiles();
    }

    @Provides
    StopMisclickingTilesConfig provideConfig(ConfigManager configManager) {
        return (StopMisclickingTilesConfig)configManager.getConfig(StopMisclickingTilesConfig.class);
    }

    List<WorldPoint> getDisabledPoints() {
        return this.disabledPoints;
    }
}

