/*
 * Decompiled with CFR 0.152.
 */
package com.httpeventserver;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.inject.Provides;
import com.httpeventserver.HttpEventServerConfig;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.NPC;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.NpcLootReceived;
import net.runelite.client.game.ItemStack;
import net.runelite.client.game.NPCManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Http Event Server", description="Exposes current player stats, actions and inventory as well as current Enemy NPC stats on <PORT>. Defaults to Port:5050", tags={"status", "npc and player stats", "api", "stats"}, enabledByDefault=true)
public class HttpEventServerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(HttpEventServerPlugin.class);
    @Inject
    private NPCManager npcManager;
    @Inject
    public Client client;
    public long startTime = 0L;
    @Inject
    public HttpEventServerConfig config;
    @Inject
    public ClientThread clientThread;
    public HttpServer server;
    public String msg;
    public String msgType;
    private boolean lastBankOpenStatus;
    public Item[] bankItems;
    public String interactingCode;
    public JsonArray lootArray = new JsonArray();
    private ItemContainer lastBankContainer;
    private ItemContainer fishingTrawlerContainer;
    public Boolean bankOpen;
    private boolean lastShopOpenStatus;
    private boolean lastTrawlerRewardOpenStatus;
    public Boolean shopOpen;
    public Boolean trawlerRewardOpen;
    public Integer tickCount = 0;
    public Integer msgTick = 0;
    public JsonObject interactingJson = new JsonObject();
    public JsonObject npcJson = new JsonObject();

    @Provides
    private HttpEventServerConfig provideConfig(ConfigManager configManager) {
        return (HttpEventServerConfig)configManager.getConfig(HttpEventServerConfig.class);
    }

    protected void startUp() throws Exception {
        String HttpPort = this.config.apiPort();
        System.out.println("HttpEventServer plugin running on Port: " + HttpPort);
        int HttpPortNumber = Integer.parseInt(HttpPort);
        this.server = HttpServer.create(new InetSocketAddress(HttpPortNumber), 0);
        this.server.createContext("/inv", this.handlerForInventory());
        this.server.createContext("/equip", this.handlerForEquipment());
        this.server.createContext("/bank", this.handlerForBank());
        this.server.createContext("/events", this::handleEvents);
        this.server.setExecutor(Executors.newSingleThreadExecutor());
        this.startTime = System.currentTimeMillis();
        this.server.start();
    }

    protected void shutDown() throws Exception {
        this.server.stop(1);
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        this.msg = event.getMessage();
        this.msgType = String.valueOf(event.getType());
        this.msgTick = this.client.getTickCount();
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.tickCount = this.client.getTickCount();
        this.detectBankWindowClosing();
        this.detectShopWindowClosing();
        this.detectTrawlerNetClosing();
        this.removeOldItems();
    }

    private void removeOldItems() {
        if (this.lootArray.size() > 0) {
            JsonArray lootArrayCopy = this.lootArray.deepCopy();
            for (JsonElement drops : this.lootArray) {
                int dropTickCount = 0;
                try {
                    dropTickCount = Integer.parseInt(drops.getAsJsonObject().get("tickCount").getAsString());
                }
                catch (Exception e) {
                    dropTickCount = 0;
                }
                if (this.tickCount - dropTickCount <= 200) continue;
                lootArrayCopy.remove(0);
            }
            this.lootArray = lootArrayCopy;
        }
    }

    private void detectBankWindowClosing() {
        Widget con = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (con != null) {
            this.lastBankOpenStatus = true;
            this.lastBankContainer = this.client.getItemContainer(InventoryID.BANK);
            this.bankOpen = Boolean.TRUE;
        } else if (this.lastBankOpenStatus) {
            this.lastBankOpenStatus = false;
            this.bankItems = this.lastBankContainer.getItems();
            this.bankOpen = Boolean.FALSE;
        }
    }

    private void detectShopWindowClosing() {
        Widget con = this.client.getWidget(WidgetInfo.SHOP_INVENTORY_ITEMS_CONTAINER);
        if (con != null) {
            this.lastShopOpenStatus = true;
            this.shopOpen = Boolean.TRUE;
        } else if (this.lastShopOpenStatus) {
            this.lastShopOpenStatus = false;
            this.shopOpen = Boolean.FALSE;
        }
    }

    private void detectTrawlerNetClosing() {
        ItemContainer reward = this.client.getItemContainer(InventoryID.FISHING_TRAWLER_REWARD);
        if (reward != null) {
            this.lastTrawlerRewardOpenStatus = true;
            this.trawlerRewardOpen = Boolean.TRUE;
        } else if (this.lastTrawlerRewardOpenStatus) {
            this.lastTrawlerRewardOpenStatus = false;
            this.trawlerRewardOpen = Boolean.FALSE;
        }
    }

    public Client getClient() {
        return this.client;
    }

    @Subscribe
    public void onNpcLootReceived(NpcLootReceived npcLootReceived) {
        int count = 0;
        JsonObject loot = new JsonObject();
        JsonArray itemList = new JsonArray();
        String npcId = String.valueOf(npcLootReceived.getNpc());
        JsonElement npcObject = this.interactingJson.get(this.interactingCode);
        for (ItemStack item : npcLootReceived.getItems()) {
            JsonObject dict = new JsonObject();
            dict.addProperty("id", (Number)item.getId());
            dict.addProperty("quantity", (Number)item.getQuantity());
            itemList.add((JsonElement)dict);
            ++count;
        }
        loot.add("loot", (JsonElement)itemList);
        loot.add("npc", npcObject);
        loot.addProperty("tickCount", (Number)this.client.getTickCount());
        loot.addProperty("interactingCode", npcId);
        this.lootArray.add((JsonElement)loot);
    }

    public Map<String, String> queryToMap(String query) {
        if (query == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String param : query.split("&")) {
            String[] entry = param.split("=");
            if (entry.length > 1) {
                result.put(entry[0], entry[1]);
                continue;
            }
            result.put(entry[0], "");
        }
        return result;
    }

    public void handleEvents(HttpExchange exchange) throws IOException {
        Player player = this.client.getLocalPlayer();
        Actor npcTarget = player.getInteracting();
        String resetLootArray = "";
        try {
            Map<String, String> params = this.queryToMap(exchange.getRequestURI().getQuery());
            if (params.containsKey("resetLootArray")) {
                resetLootArray = params.get("resetLootArray");
            }
        }
        catch (Exception params) {
            // empty catch block
        }
        int npcMaxHealth = 0;
        int npcCurrentHealth = 0;
        int npcCombatLvl = 0;
        int npcX = 0;
        int npcY = 0;
        int npcPlane = 0;
        int npcRegionID = 0;
        int npcRegionX = 0;
        int npcRegionY = 0;
        int npcId = 0;
        String npcName = "";
        if (npcTarget != null) {
            this.interactingCode = String.valueOf(player.getInteracting());
            int npcHealthRatio = npcTarget.getHealthRatio();
            int npcHealthScale = npcTarget.getHealthScale();
            if (npcTarget instanceof NPC) {
                npcId = ((NPC)npcTarget).getId();
                npcMaxHealth = this.npcManager.getHealth(((NPC)npcTarget).getId());
                npcName = npcTarget.getName();
                npcCombatLvl = npcTarget.getCombatLevel();
                npcX = npcTarget.getWorldLocation().getX();
                npcY = npcTarget.getWorldLocation().getY();
                npcPlane = npcTarget.getWorldLocation().getPlane();
                npcRegionID = npcTarget.getWorldLocation().getRegionID();
                npcRegionX = npcTarget.getWorldLocation().getRegionX();
                npcRegionY = npcTarget.getWorldLocation().getRegionY();
                JsonObject dict = new JsonObject();
                if (!this.interactingJson.has(this.interactingCode)) {
                    dict.addProperty("name", npcName);
                    dict.addProperty("id", (Number)npcId);
                    this.interactingJson.add(this.interactingCode, (JsonElement)dict);
                }
            }
            npcCurrentHealth = HttpEventServerPlugin.getNpcCurrentHealth(npcHealthRatio, npcHealthScale, npcMaxHealth, npcCurrentHealth);
        }
        JsonObject object = new JsonObject();
        JsonObject camera = new JsonObject();
        JsonObject playerCoordinates = new JsonObject();
        JsonObject npcCoordinates = new JsonObject();
        JsonObject playerObject = new JsonObject();
        JsonObject npcObject = new JsonObject();
        object.addProperty("latestMsg", this.msg);
        object.addProperty("gameCycle", (Number)this.client.getGameCycle());
        object.addProperty("tickCount", (Number)this.tickCount);
        object.addProperty("latestMsg", this.msg);
        object.addProperty("latestMsgType", this.msgType);
        object.addProperty("msgTick", (Number)this.msgTick);
        object.addProperty("bankOpen", this.bankOpen);
        object.addProperty("shopOpen", this.shopOpen);
        object.addProperty("trawlerRewardOpen", this.trawlerRewardOpen);
        playerObject.addProperty("animation", (Number)player.getAnimation());
        playerObject.addProperty("animationPose", (Number)player.getPoseAnimation());
        playerObject.addProperty("interactingCode", String.valueOf(player.getInteracting()));
        playerObject.addProperty("runEnergy", (Number)this.client.getEnergy());
        playerObject.addProperty("specialAttackEnergy", (Number)this.client.getVarpValue(300));
        playerObject.addProperty("currentPrayer", (Number)this.client.getBoostedSkillLevel(Skill.PRAYER));
        playerObject.addProperty("maxPrayer", (Number)this.client.getRealSkillLevel(Skill.PRAYER));
        playerObject.addProperty("currentHealth", (Number)this.client.getBoostedSkillLevel(Skill.HITPOINTS));
        playerObject.addProperty("maxHealth", (Number)this.client.getRealSkillLevel(Skill.HITPOINTS));
        playerCoordinates.addProperty("x", (Number)player.getWorldLocation().getX());
        playerCoordinates.addProperty("y", (Number)player.getWorldLocation().getY());
        playerCoordinates.addProperty("plane", (Number)player.getWorldLocation().getPlane());
        playerCoordinates.addProperty("regionID", (Number)player.getWorldLocation().getRegionID());
        playerCoordinates.addProperty("regionX", (Number)player.getWorldLocation().getRegionX());
        playerCoordinates.addProperty("regionY", (Number)player.getWorldLocation().getRegionY());
        npcObject.addProperty("name", npcName);
        npcObject.addProperty("id", (Number)npcId);
        npcObject.addProperty("combatLevel ", (Number)npcCombatLvl);
        npcObject.addProperty("currentHealth ", (Number)npcCurrentHealth);
        npcObject.addProperty("maxHealth ", (Number)npcMaxHealth);
        npcCoordinates.addProperty("x", (Number)npcX);
        npcCoordinates.addProperty("y", (Number)npcY);
        npcCoordinates.addProperty("plane", (Number)npcPlane);
        npcCoordinates.addProperty("regionID", (Number)npcRegionID);
        npcCoordinates.addProperty("regionX", (Number)npcRegionX);
        npcCoordinates.addProperty("regionY", (Number)npcRegionY);
        camera.addProperty("yaw", (Number)this.client.getCameraYaw());
        camera.addProperty("pitch", (Number)this.client.getCameraPitch());
        camera.addProperty("x", (Number)this.client.getCameraX());
        camera.addProperty("y", (Number)this.client.getCameraY());
        camera.addProperty("z", (Number)this.client.getCameraZ());
        camera.addProperty("x2", (Number)this.client.getCameraX2());
        camera.addProperty("y2", (Number)this.client.getCameraY2());
        camera.addProperty("z2", (Number)this.client.getCameraZ2());
        playerObject.add("playerCoordinates", (JsonElement)playerCoordinates);
        npcObject.add("npcCoordinates", (JsonElement)npcCoordinates);
        object.add("camera", (JsonElement)camera);
        object.add("playerObject", (JsonElement)playerObject);
        object.add("npcObject", (JsonElement)npcObject);
        object.add("lootArray", (JsonElement)this.lootArray);
        if (resetLootArray.equals("1")) {
            this.lootArray = new JsonArray();
        }
        exchange.sendResponseHeaders(200, 0L);
        try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
            RuneLiteAPI.GSON.toJson((JsonElement)object, (Appendable)out);
        }
    }

    public static int getNpcCurrentHealth(int npcHealthRatio, int npcHealthScale, int npcMaxHealth, int npcCurrentHealth) {
        if (npcHealthRatio > 0) {
            int maximumHP;
            int minimumHP = 1;
            if (npcHealthScale > 1) {
                if (npcHealthRatio > 1) {
                    minimumHP = (npcMaxHealth * (npcHealthRatio - 1) + npcHealthScale - 2) / (npcHealthScale - 1);
                }
                if ((maximumHP = (npcMaxHealth * npcHealthRatio - 1) / (npcHealthScale - 1)) > npcMaxHealth) {
                    maximumHP = npcMaxHealth;
                }
            } else {
                maximumHP = npcMaxHealth;
            }
            npcCurrentHealth = (minimumHP + maximumHP + 1) / 2;
        }
        return npcCurrentHealth;
    }

    private HttpHandler handlerForInventory() {
        return exchange -> {
            Item[] items = this.invokeAndWait(() -> {
                ItemContainer itemContainer = this.client.getItemContainer(InventoryID.INVENTORY);
                if (itemContainer != null) {
                    return itemContainer.getItems();
                }
                return null;
            });
            if (items == null) {
                ArrayList emptyArray = new ArrayList();
                exchange.sendResponseHeaders(200, 0L);
                try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
                    RuneLiteAPI.GSON.toJson(emptyArray, (Appendable)out);
                }
            }
            ArrayList itemArray = new ArrayList();
            int count = 0;
            for (Item i : items) {
                HashMap<String, Integer> dict = new HashMap<String, Integer>();
                dict.put("id", i.getId());
                dict.put("invSlot", count);
                dict.put("quantity", i.getQuantity());
                itemArray.add(dict);
                ++count;
            }
            exchange.sendResponseHeaders(200, 0L);
            try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
                RuneLiteAPI.GSON.toJson(itemArray, (Appendable)out);
            }
        };
    }

    private HttpHandler handlerForBank() {
        return exchange -> {
            if (this.bankItems == null) {
                ArrayList emptyArray = new ArrayList();
                exchange.sendResponseHeaders(200, 0L);
                try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
                    RuneLiteAPI.GSON.toJson(emptyArray, (Appendable)out);
                }
            }
            exchange.sendResponseHeaders(200, 0L);
            try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
                RuneLiteAPI.GSON.toJson((Object)this.bankItems, (Appendable)out);
            }
        };
    }

    private HttpHandler handlerForEquipment() {
        return exchange -> {
            Item[] items = this.invokeAndWait(() -> {
                ItemContainer itemContainer = this.client.getItemContainer(InventoryID.EQUIPMENT);
                if (itemContainer != null) {
                    return itemContainer.getItems();
                }
                return null;
            });
            if (items == null) {
                ArrayList emptyArray = new ArrayList();
                exchange.sendResponseHeaders(200, 0L);
                try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
                    RuneLiteAPI.GSON.toJson(emptyArray, (Appendable)out);
                }
            }
            JsonObject equipmentObject = new JsonObject();
            int count = 0;
            for (Item i : items) {
                JsonObject slot = new JsonObject();
                slot.addProperty("id", (Number)i.getId());
                slot.addProperty("quantity", (Number)i.getQuantity());
                if (equipmentSlots.values()[count] != equipmentSlots.placeholderA && equipmentSlots.values()[count] != equipmentSlots.placeholderB && equipmentSlots.values()[count] != equipmentSlots.placeholderC) {
                    equipmentObject.add(String.valueOf((Object)equipmentSlots.values()[count]), (JsonElement)slot);
                }
                ++count;
            }
            exchange.sendResponseHeaders(200, 0L);
            try (OutputStreamWriter out = new OutputStreamWriter(exchange.getResponseBody());){
                RuneLiteAPI.GSON.toJson((JsonElement)equipmentObject, (Appendable)out);
            }
        };
    }

    private <T> T invokeAndWait(Callable<T> r) {
        try {
            AtomicReference ref = new AtomicReference();
            Semaphore semaphore = new Semaphore(0);
            this.clientThread.invokeLater(() -> {
                try {
                    ref.set(r.call());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    semaphore.release();
                }
            });
            semaphore.acquire();
            return (T)ref.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum equipmentSlots {
        head,
        back,
        neck,
        weapon,
        chest,
        shield,
        placeholderA,
        legs,
        placeholderB,
        gloves,
        boots,
        placeholderC,
        ring,
        ammo;

    }
}

