/*
 * Decompiled with CFR 0.152.
 */
package com.majiru.bankregex;

import com.google.inject.Provides;
import com.majiru.bankregex.BankRegexSearchConfig;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.game.chatbox.ChatboxPanelManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Regex Bank Search")
public class BankRegexSearchPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankRegexSearchPlugin.class);
    @Inject
    private Client client;
    @Inject
    ChatboxPanelManager chatboxPanelManager;
    @Inject
    ClientThread clientThread;
    @Inject
    private BankRegexSearchConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configmanager;
    private static final String CONFIG_GROUP = "regexbanksearch";
    private Query manual;
    private Query bookmark;
    private boolean filtering;

    public void startUp() {
        this.manual = new Query(null, null, null);
    }

    @Provides
    BankRegexSearchConfig getConfig(ConfigManager configManager) {
        return (BankRegexSearchConfig)configManager.getConfig(BankRegexSearchConfig.class);
    }

    public void resetConfiguration() {
        List keys = this.configmanager.getConfigurationKeys("regexbanksearch.bookmark_");
        for (String key : keys) {
            String[] str = key.split("\\.", 2);
            if (str.length != 2) continue;
            this.configmanager.unsetConfiguration(str[0], str[1]);
        }
    }

    private Optional<String> clean(String query) {
        if (!query.startsWith("/") || query.length() < 2) {
            return Optional.empty();
        }
        if (this.config.requireTerminator() && !query.endsWith("/")) {
            return Optional.empty();
        }
        return query.endsWith("/") ? Optional.of(query.substring(1, query.length() - 1)) : Optional.of(query.substring(1));
    }

    private boolean search(Query q, int itemId, String str) {
        String name;
        Optional<String> userQuery = this.clean(str);
        if (!userQuery.isPresent()) {
            return false;
        }
        String rawName = this.itemManager.getItemComposition(itemId).getName();
        String string = name = this.config.ignoreCase() ? rawName.toLowerCase() : rawName;
        if (q.search == null || !q.search.equals(userQuery.get())) {
            q.search = userQuery.get();
            try {
                q.pattern = Pattern.compile(q.search);
            }
            catch (PatternSyntaxException e) {
                q.pattern = null;
            }
        }
        return q.pattern != null && q.pattern.matcher(name).find(0);
    }

    private boolean bookmarkSearch(int itemId) {
        if (this.bookmark == null) {
            return false;
        }
        String query = this.configmanager.getConfiguration(CONFIG_GROUP, "bookmark_" + this.bookmark.name);
        if (query == null) {
            return false;
        }
        return this.search(this.bookmark, itemId, "/" + query + "/");
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        if (event.getScriptId() == 281) {
            this.bookmark = null;
            this.clientThread.invoke(() -> this.layoutBank(""));
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!event.getEventName().equals("bankSearchFilter")) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        String[] stringStack = this.client.getStringStack();
        int intStackSize = this.client.getIntStackSize();
        int stringStackSize = this.client.getStringStackSize();
        int itemId = intStack[intStackSize - 1];
        String search = stringStack[stringStackSize - 1];
        if (this.bookmark != null) {
            if (this.bookmarkSearch(itemId)) {
                intStack[intStackSize - 2] = 1;
            }
            return;
        }
        if (this.search(this.manual, itemId, search)) {
            intStack[intStackSize - 2] = 1;
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        boolean bankOpen;
        if (!this.filtering || this.bookmark == null || event.getScriptId() != 514) {
            return;
        }
        boolean bl = bankOpen = this.client.getItemContainer(InventoryID.BANK) != null;
        if (this.client.getItemContainer(InventoryID.BANK) != null) {
            this.client.getIntStack()[this.client.getIntStackSize() - 1] = 1;
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        Widget bankSettings = this.client.getWidget(WidgetInfo.BANK_SETTINGS_BUTTON);
        if (bankSettings == null || bankSettings.isHidden()) {
            return;
        }
        if (event.getOption().equals("Show menu")) {
            this.clientThread.invoke(this::buildMenus);
        }
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (!this.filtering) {
            return;
        }
        Widget bankContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (bankContainer == null || bankContainer.isHidden()) {
            return;
        }
        String option = event.getMenuOption();
        if (option.startsWith("View tab") || option.equals("View all items") || option.startsWith("View tag tab")) {
            this.bookmark = null;
            this.clientThread.invoke(() -> this.layoutBank(""));
        }
    }

    private void editBookmark(MenuEntry entry) {
        if (this.manual.search == null) {
            return;
        }
        this.chatboxPanelManager.openTextInput("Name of bookmark").onDone(newValue -> this.clientThread.invoke(() -> {
            String name = newValue.replaceAll("[<>/]]", "");
            if (name.length() == 0) {
                return;
            }
            this.configmanager.setConfiguration(CONFIG_GROUP, "bookmark_" + name, this.manual.search);
            this.bookmark = new Query(name, null, null);
            this.manual.search = null;
        })).build();
    }

    private void layoutBank(String query) {
        this.filtering = !query.equals("");
        Widget bankContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (bankContainer == null || bankContainer.isHidden()) {
            return;
        }
        Object[] scriptArgs = bankContainer.getOnInvTransmitListener();
        if (scriptArgs == null) {
            return;
        }
        this.client.setVarcStrValue(359, query);
        this.client.runScript(scriptArgs);
        Widget searchBackground = this.client.getWidget(WidgetInfo.BANK_SEARCH_BUTTON_BACKGROUND);
        searchBackground.setSpriteId(170);
    }

    private void buildMenus() {
        this.client.createMenuEntry(-1).setOption("Add regex bookmark").setIdentifier(1).setType(MenuAction.RUNELITE).onClick(this::editBookmark);
        List keys = this.configmanager.getConfigurationKeys("regexbanksearch.bookmark_");
        if (this.bookmark != null) {
            keys = keys.stream().filter(s -> {
                String[] str = s.split("_", 2);
                return str.length < 2 || !str[1].equals(this.bookmark.name);
            }).collect(Collectors.toList());
            this.client.createMenuEntry(-1).setOption("Delete " + this.bookmark.name).setType(MenuAction.RUNELITE).onClick(e -> {
                this.configmanager.unsetConfiguration(CONFIG_GROUP, "bookmark_" + this.bookmark.name);
                this.bookmark = null;
                this.clientThread.invoke(() -> this.layoutBank(""));
            });
        }
        for (String key : keys) {
            String[] str = key.split("_", 2);
            this.client.createMenuEntry(-1).setOption(str[1]).setType(MenuAction.RUNELITE).onClick(e -> {
                String query = this.configmanager.getConfiguration(CONFIG_GROUP, "bookmark_" + str[1]);
                this.bookmark = new Query(str[1], null, null);
                this.clientThread.invoke(() -> this.layoutBank(query));
            });
        }
        if (this.bookmark == null) {
            return;
        }
        this.client.createMenuEntry(-1).setOption("Close bookmark").setType(MenuAction.RUNELITE).onClick(e -> {
            this.bookmark = null;
            this.clientThread.invoke(() -> this.layoutBank(""));
        });
    }

    class Query {
        String name;
        String search;
        Pattern pattern;

        public Query(String name, String search, Pattern pattern) {
            this.name = name;
            this.search = search;
            this.pattern = pattern;
        }
    }
}

