/*
 * Decompiled with CFR 0.152.
 */
package xyz.amrik;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Provides;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Item;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import xyz.amrik.JekyllHerbReminderConfig;

@PluginDescriptor(name="Jekyll Herb Reminder")
public class JekyllHerbReminderPlugin
extends Plugin {
    @Inject
    private Notifier notifier;
    @Inject
    private JekyllHerbReminderConfig config;
    private static final int INVENTORY_ID = 93;
    private static final ImmutableMap<JekyllHerbReminderConfig.RewardWantedType, Integer> REWARD_TO_HERB = ImmutableMap.builder().put((Object)JekyllHerbReminderConfig.RewardWantedType.STRENGTH_POTION, (Object)249).put((Object)JekyllHerbReminderConfig.RewardWantedType.ANTIPOISON, (Object)251).put((Object)JekyllHerbReminderConfig.RewardWantedType.ATTACK_POTION, (Object)253).put((Object)JekyllHerbReminderConfig.RewardWantedType.RESTORE_POTION, (Object)255).put((Object)JekyllHerbReminderConfig.RewardWantedType.ENERGY_POTION, (Object)257).put((Object)JekyllHerbReminderConfig.RewardWantedType.DEFENCE_POTION, (Object)2998).put((Object)JekyllHerbReminderConfig.RewardWantedType.AGILITY_POTION, (Object)259).put((Object)JekyllHerbReminderConfig.RewardWantedType.SUPER_ATTACK, (Object)261).put((Object)JekyllHerbReminderConfig.RewardWantedType.SUPER_ENERGY, (Object)263).put((Object)JekyllHerbReminderConfig.RewardWantedType.SUPER_STRENGTH, (Object)3000).put((Object)JekyllHerbReminderConfig.RewardWantedType.SUPER_RESTORE, (Object)265).put((Object)JekyllHerbReminderConfig.RewardWantedType.SUPER_DEFENCE, (Object)2481).put((Object)JekyllHerbReminderConfig.RewardWantedType.MAGIC_POTION, (Object)267).put((Object)JekyllHerbReminderConfig.RewardWantedType.STAMINA_POTION, (Object)269).build();

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged itemContainerChanged) {
        if (itemContainerChanged.getContainerId() != 93 || this.config.rewardWantedType() == JekyllHerbReminderConfig.RewardWantedType.DEFAULT) {
            return;
        }
        int herbWantedID = (Integer)REWARD_TO_HERB.get((Object)this.config.rewardWantedType());
        Item[] inventory = itemContainerChanged.getItemContainer().getItems();
        boolean inventoryContainsHerb = Arrays.stream(inventory).map(Item::getId).anyMatch(id -> id == herbWantedID);
        if (!inventoryContainsHerb) {
            this.notifier.notify("You no longer have the correct herb for Jekyll & Hyde event in your inventory!");
        }
    }

    @Provides
    JekyllHerbReminderConfig getConfig(ConfigManager configManager) {
        return (JekyllHerbReminderConfig)configManager.getConfig(JekyllHerbReminderConfig.class);
    }
}

