/*
 * Decompiled with CFR 0.152.
 */
package com.herblorerecipes.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.herblorerecipes.model.Potion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public enum Potions {
    IMP_REPELLENT(Potion.builder().level(3).name("Imp repellent").basicBase(11264).secondaries((Set<Integer>)ImmutableSet.of((Object)6010, (Object)6014, (Object)6012, (Object)2460, (Object)2462, (Object)2464, (Object[])new Integer[]{2466, 2468, 2470, 2472, 2476, 2474})).ids((Set<Integer>)ImmutableSet.of((Object)11262)).build()),
    ATTACK_POTION(Potion.builder().level(3).name("Attack potion").basicBase(227).primary(249).grimyHerb(199).primarySeed(5291).secondaries((Set<Integer>)ImmutableSet.of((Object)221)).unfinishedPotion(91).ids((Set<Integer>)ImmutableSet.of((Object)125, (Object)123, (Object)121, (Object)2428)).build()),
    ANTIPOISON(Potion.builder().level(5).name("Antipoison").basicBase(227).primary(251).grimyHerb(201).primarySeed(5292).secondaries((Set<Integer>)ImmutableSet.of((Object)235)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)237)).unfinishedPotion(93).ids((Set<Integer>)ImmutableSet.of((Object)179, (Object)177, (Object)175, (Object)2446)).build()),
    RELICYMS_BALM(Potion.builder().level(8).name("Relicym's balm").basicBase(227).primary(1534).grimyHerb(1533).secondaries((Set<Integer>)ImmutableSet.of((Object)1526)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)1525)).unfinishedPotion(4840).ids((Set<Integer>)ImmutableSet.of((Object)4848, (Object)4846, (Object)4844, (Object)4842)).build()),
    STRENGTH_POTION(Potion.builder().level(12).name("Strength potion").basicBase(227).primary(253).grimyHerb(203).primarySeed(5293).secondaries((Set<Integer>)ImmutableSet.of((Object)225)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)5100)).unfinishedPotion(95).ids((Set<Integer>)ImmutableSet.of((Object)119, (Object)117, (Object)115, (Object)113)).build()),
    SERUM_207(Potion.builder().level(15).name("Serum 207").basicBase(227).primary(253).grimyHerb(203).primarySeed(5293).secondaries((Set<Integer>)ImmutableSet.of((Object)592)).unfinishedPotion(95).ids((Set<Integer>)ImmutableSet.of((Object)3414, (Object)3412, (Object)3410, (Object)3408)).build()),
    GUTHIX_REST_TEA(Potion.builder().level(18).name("Guthix rest tea").basicBase(4460).primary(255).grimyHerb(205).primarySeed(5294).secondaries((Set<Integer>)ImmutableSet.of((Object)249, (Object)251)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)199, (Object)201)).unfinishedPotion(97).ids((Set<Integer>)ImmutableSet.of((Object)4423, (Object)4421, (Object)4419, (Object)4417)).build()),
    COMPOST_POTION(Potion.builder().level(22).name("Compost potion").basicBase(227).primary(255).grimyHerb(205).primarySeed(5294).secondaries((Set<Integer>)ImmutableSet.of((Object)21622)).unfinishedPotion(97).ids((Set<Integer>)ImmutableSet.of((Object)6476, (Object)6474, (Object)6472, (Object)6470)).build()),
    RESTORE_POTION(Potion.builder().level(22).name("Restore potion").basicBase(227).primary(255).grimyHerb(205).primarySeed(5294).secondaries((Set<Integer>)ImmutableSet.of((Object)223)).unfinishedPotion(97).ids((Set<Integer>)ImmutableSet.of((Object)131, (Object)129, (Object)127, (Object)2430)).build()),
    BLAMISH_OIL(Potion.builder().level(25).name("Blamish oil").basicBase(227).primary(255).grimyHerb(205).primarySeed(5294).secondaries((Set<Integer>)ImmutableSet.of((Object)1581)).unfinishedPotion(97).ids((Set<Integer>)ImmutableSet.of((Object)1582)).build()),
    ENERGY_POTION(Potion.builder().level(26).name("Energy potion").basicBase(227).primary(255).grimyHerb(205).primarySeed(5294).secondaries((Set<Integer>)ImmutableSet.of((Object)1975)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)1973)).unfinishedPotion(97).ids((Set<Integer>)ImmutableSet.of((Object)3014, (Object)3012, (Object)3010, (Object)3008)).build()),
    DEFENCE_POTION(Potion.builder().level(30).name("Defence potion").basicBase(227).primary(257).grimyHerb(207).primarySeed(5295).secondaries((Set<Integer>)ImmutableSet.of((Object)239)).unfinishedPotion(99).ids((Set<Integer>)ImmutableSet.of((Object)137, (Object)135, (Object)133, (Object)2432)).build()),
    AGILITY_POTION(Potion.builder().level(34).name("Agility potion").basicBase(227).primary(2998).grimyHerb(3049).primarySeed(5296).secondaries((Set<Integer>)ImmutableSet.of((Object)2152)).unfinishedPotion(3002).ids((Set<Integer>)ImmutableSet.of((Object)3038, (Object)3036, (Object)3034, (Object)3032)).build()),
    COMBAT_POTION(Potion.builder().level(36).name("Combat potion").basicBase(227).primary(255).grimyHerb(205).primarySeed(5294).secondaries((Set<Integer>)ImmutableSet.of((Object)9736)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)9735)).unfinishedPotion(97).ids((Set<Integer>)ImmutableSet.of((Object)9745, (Object)9743, (Object)9741, (Object)9739)).build()),
    PRAYER_POTION(Potion.builder().level(38).name("Prayer potion").basicBase(227).primary(257).grimyHerb(207).primarySeed(5295).secondaries((Set<Integer>)ImmutableSet.of((Object)231)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)22879)).unfinishedPotion(99).ids((Set<Integer>)ImmutableSet.of((Object)143, (Object)141, (Object)139, (Object)2434)).build()),
    SUPER_ATTACK(Potion.builder().level(45).name("Super attack").basicBase(227).primary(259).grimyHerb(209).primarySeed(5297).secondaries((Set<Integer>)ImmutableSet.of((Object)221)).unfinishedPotion(101).ids((Set<Integer>)ImmutableSet.of((Object)149, (Object)147, (Object)145, (Object)2436)).build()),
    GOBLIN_POTION(Potion.builder().level(47).name("Goblin potion").basicBase(227).primary(2998).grimyHerb(3049).primarySeed(5296).secondaries((Set<Integer>)ImmutableSet.of((Object)26569)).unfinishedPotion(3002).ids((Set<Integer>)ImmutableSet.of((Object)26587, (Object)26585, (Object)26583, (Object)26581)).build()),
    SUPERANTIPOISON(Potion.builder().level(48).name("Superantipoison").basicBase(227).primary(259).grimyHerb(209).primarySeed(5297).secondaries((Set<Integer>)ImmutableSet.of((Object)235)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)237)).unfinishedPotion(101).ids((Set<Integer>)ImmutableSet.of((Object)185, (Object)183, (Object)181, (Object)2448)).build()),
    FISHING_POTION(Potion.builder().level(50).name("Fishing potion").basicBase(227).primary(261).grimyHerb(211).primarySeed(5298).secondaries((Set<Integer>)ImmutableSet.of((Object)231)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)22879)).unfinishedPotion(103).ids((Set<Integer>)ImmutableSet.of((Object)155, (Object)153, (Object)151, (Object)2438)).build()),
    SUPER_ENERGY(Potion.builder().level(52).name("Super energy").basicBase(227).primary(261).grimyHerb(211).primarySeed(5298).secondaries((Set<Integer>)ImmutableSet.of((Object)2970)).unfinishedPotion(103).ids((Set<Integer>)ImmutableSet.of((Object)3022, (Object)3020, (Object)3018, (Object)3016)).build()),
    SHRINK_ME_QUICK(Potion.builder().level(52).name("Shrink-me-quick").basicBase(227).primary(253).grimyHerb(203).primarySeed(5293).secondaries((Set<Integer>)ImmutableSet.of((Object)11205)).unfinishedPotion(95).ids((Set<Integer>)ImmutableSet.of((Object)11204)).build()),
    HUNTER_POTION(Potion.builder().level(53).name("Hunter potion").basicBase(227).primary(261).grimyHerb(211).primarySeed(5298).secondaries((Set<Integer>)ImmutableSet.of((Object)10111)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)10109)).unfinishedPotion(103).ids((Set<Integer>)ImmutableSet.of((Object)10004, (Object)10002, (Object)10000, (Object)9998)).build()),
    SUPER_STRENGTH(Potion.builder().level(55).name("Super strength").basicBase(227).primary(263).grimyHerb(213).primarySeed(5299).secondaries((Set<Integer>)ImmutableSet.of((Object)225)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)5100)).unfinishedPotion(105).ids((Set<Integer>)ImmutableSet.of((Object)161, (Object)159, (Object)157, (Object)2440)).build()),
    MAGIC_ESSENCE(Potion.builder().level(57).name("Magic essence").basicBase(227).primary(9017).secondaries((Set<Integer>)ImmutableSet.of((Object)9018)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)9016)).unfinishedPotion(9019).ids((Set<Integer>)ImmutableSet.of((Object)9024, (Object)9023, (Object)9022, (Object)9021)).build()),
    WEAPON_POISON(Potion.builder().level(60).name("Weapon poison").basicBase(227).primary(263).grimyHerb(213).primarySeed(5299).secondaries((Set<Integer>)ImmutableSet.of((Object)241)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)243)).unfinishedPotion(105).ids((Set<Integer>)ImmutableSet.of((Object)187)).build()),
    SUPER_RESTORE(Potion.builder().level(63).name("Super restore").basicBase(227).primary(3000).grimyHerb(3051).primarySeed(5300).secondaries((Set<Integer>)ImmutableSet.of((Object)223)).unfinishedPotion(3004).ids((Set<Integer>)ImmutableSet.of((Object)3030, (Object)3028, (Object)3026, (Object)3024)).build()),
    SUPER_DEFENCE(Potion.builder().level(66).name("Super defence").basicBase(227).primary(265).grimyHerb(215).primarySeed(5301).secondaries((Set<Integer>)ImmutableSet.of((Object)239)).unfinishedPotion(107).ids((Set<Integer>)ImmutableSet.of((Object)167, (Object)165, (Object)163, (Object)2442)).build()),
    ANTIDOTE_PLUS(Potion.builder().level(68).name("Antidote+").basicBase(5935).primary(2998).grimyHerb(3049).primarySeed(5296).secondaries((Set<Integer>)ImmutableSet.of((Object)6049)).unfinishedPotion(3002).ids((Set<Integer>)ImmutableSet.of((Object)5949, (Object)5947, (Object)5945, (Object)5943)).build()),
    ANTIFIRE_POTION(Potion.builder().level(69).name("Antifire potion").basicBase(227).primary(2481).grimyHerb(2485).primarySeed(5302).secondaries((Set<Integer>)ImmutableSet.of((Object)241)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)243)).unfinishedPotion(2483).ids((Set<Integer>)ImmutableSet.of((Object)2458, (Object)2456, (Object)2454, (Object)2452)).build()),
    RANGING_POTION(Potion.builder().level(72).name("Ranging potion").basicBase(227).primary(267).grimyHerb(217).primarySeed(5303).secondaries((Set<Integer>)ImmutableSet.of((Object)245)).unfinishedPotion(109).ids((Set<Integer>)ImmutableSet.of((Object)173, (Object)171, (Object)169, (Object)2444)).build()),
    WEAPON_POISON_PLUS(Potion.builder().level(73).name("Weapon poison+").basicBase(5935).primary(6016).secondaries((Set<Integer>)ImmutableSet.of((Object)223)).unfinishedPotion(5936).ids((Set<Integer>)ImmutableSet.of((Object)5937)).build()),
    MAGIC_POTION(Potion.builder().level(76).name("Magic potion").basicBase(227).primary(2481).grimyHerb(2485).primarySeed(5302).secondaries((Set<Integer>)ImmutableSet.of((Object)3138)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)22873)).unfinishedPotion(2483).ids((Set<Integer>)ImmutableSet.of((Object)3046, (Object)3044, (Object)3042, (Object)3040)).build()),
    ZAMORAK_BREW(Potion.builder().level(78).name("Zamorak brew").basicBase(227).primary(269).grimyHerb(219).primarySeed(5304).secondaries((Set<Integer>)ImmutableSet.of((Object)247)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)5104)).unfinishedPotion(111).ids((Set<Integer>)ImmutableSet.of((Object)193, (Object)191, (Object)189, (Object)2450)).build()),
    ANTIDOTE_PLUS2(Potion.builder().level(79).name("Antidote++").basicBase(5935).primary(259).grimyHerb(209).primarySeed(5297).secondaries((Set<Integer>)ImmutableSet.of((Object)6051)).unfinishedPotion(101).ids((Set<Integer>)ImmutableSet.of((Object)5958, (Object)5956, (Object)5954, (Object)5952)).build()),
    BASTION_POTION(Potion.builder().level(80).name("Bastion potion").basicBase(22405).primary(265).grimyHerb(215).primarySeed(5301).secondaries((Set<Integer>)ImmutableSet.of((Object)245)).unfinishedPotion(22443).ids((Set<Integer>)ImmutableSet.of((Object)22470, (Object)22467, (Object)22464, (Object)22461)).build()),
    BATTLEMAGE_POTION(Potion.builder().level(80).name("Battlemage potion").basicBase(22405).primary(265).grimyHerb(215).primarySeed(5301).secondaries((Set<Integer>)ImmutableSet.of((Object)3138)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)22873)).unfinishedPotion(22443).ids((Set<Integer>)ImmutableSet.of((Object)22458, (Object)22455, (Object)22452, (Object)22449)).build()),
    SARADOMIN_BREW(Potion.builder().level(81).name("Saradomin brew").basicBase(227).primary(2998).grimyHerb(3049).primarySeed(5296).secondaries((Set<Integer>)ImmutableSet.of((Object)6693)).unfinishedPotion(3002).ids((Set<Integer>)ImmutableSet.of((Object)6691, (Object)6689, (Object)6687, (Object)6685)).build()),
    WEAPON_POISON_PLUS2(Potion.builder().level(82).name("Weapon poison++").basicBase(5935).primary(2398).primaryAlt(27790).secondaries((Set<Integer>)ImmutableSet.of((Object)6018)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)5106)).unfinishedPotion(5939).ids((Set<Integer>)ImmutableSet.of((Object)5940)).build()),
    ANCIENT_BREW(Potion.builder().level(85).name("Ancient brew").basicBase(227).primary(267).grimyHerb(217).primarySeed(5303).secondaries((Set<Integer>)ImmutableSet.of((Object)26368)).secondariesAlt((Set<Integer>)ImmutableSet.of((Object)26231)).unfinishedPotion(109).ids((Set<Integer>)ImmutableSet.of((Object)26346, (Object)26344, (Object)26342, (Object)26340)).build()),
    MENAPHITE_REMEDY(Potion.builder().level(88).name("Menaphite Remedy").basicBase(227).primary(267).grimyHerb(217).primarySeed(5303).secondaries((Set<Integer>)ImmutableSet.of((Object)27272)).unfinishedPotion(109).ids((Set<Integer>)ImmutableSet.of((Object)27211, (Object)27208, (Object)27205, (Object)27202)).build()),
    GUTHIX_BALANCE(Potion.builder().level(22).name("Guthix balance").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.RESTORE_POTION.potion)).primary(1550).secondaries((Set<Integer>)ImmutableSet.of((Object)7650)).ids((Set<Integer>)ImmutableSet.of((Object)7666, (Object)7664, (Object)7662, (Object)7660)).build()),
    SANFEW_SERUM(Potion.builder().level(65).name("Sanfew serum").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.SUPER_RESTORE.potion)).primary(235).primaryAlt(237).secondaries((Set<Integer>)ImmutableSet.of((Object)1526, (Object)10937)).ids((Set<Integer>)ImmutableSet.of((Object)10931, (Object)10929, (Object)10927, (Object)10925)).build()),
    DIVINE_SUPER_ATTACK(Potion.builder().level(70).name("Divine super attack potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.SUPER_ATTACK.potion)).primary(23804).primaryAlt(23962).ids((Set<Integer>)ImmutableSet.of((Object)23706, (Object)23703, (Object)23700, (Object)23697)).build()),
    DIVINE_SUPER_DEFENCE(Potion.builder().level(70).name("Divine super defence potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.SUPER_DEFENCE.potion)).primary(23804).primaryAlt(23962).ids((Set<Integer>)ImmutableSet.of((Object)23730, (Object)23727, (Object)23724, (Object)23721)).build()),
    DIVINE_SUPER_STRENGTH(Potion.builder().level(70).name("Divine super strength potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.SUPER_STRENGTH.potion)).primary(23804).primaryAlt(23962).ids((Set<Integer>)ImmutableSet.of((Object)23718, (Object)23715, (Object)23712, (Object)23709)).build()),
    DIVINE_RANGING(Potion.builder().level(74).name("Divine ranging potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.RANGING_POTION.potion)).primary(23804).primaryAlt(23962).ids((Set<Integer>)ImmutableSet.of((Object)23742, (Object)23739, (Object)23736, (Object)23733)).build()),
    STAMINA_POTION(Potion.builder().level(77).name("Stamina potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.SUPER_ENERGY.potion)).primary(12640).primaryAlt(12641).ids((Set<Integer>)ImmutableSet.of((Object)12631, (Object)12629, (Object)12627, (Object)12625)).build()),
    DIVINE_MAGIC(Potion.builder().level(78).name("Divine magic potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.MAGIC_POTION.potion)).primary(23804).primaryAlt(23962).ids((Set<Integer>)ImmutableSet.of((Object)23754, (Object)23751, (Object)23748, (Object)23745)).build()),
    EXTENDED_ANTIFIRE(Potion.builder().level(84).name("Extended antifire").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.ANTIFIRE_POTION.potion)).primary(11994).primaryAlt(11992).ids((Set<Integer>)ImmutableSet.of((Object)11957, (Object)11955, (Object)11953, (Object)11951)).build()),
    DIVINE_BASTION(Potion.builder().level(86).name("Divine bastion potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.BASTION_POTION.potion)).primary(23804).primaryAlt(23962).ids((Set<Integer>)ImmutableSet.of((Object)24644, (Object)24641, (Object)24638, (Object)24635)).build()),
    DIVINE_BATTLEMAGE(Potion.builder().level(86).name("Divine battlemage potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.BATTLEMAGE_POTION.potion)).primary(23804).primaryAlt(23962).ids((Set<Integer>)ImmutableSet.of((Object)24632, (Object)24629, (Object)24626, (Object)24623)).build()),
    ANTIVENOM(Potion.builder().level(87).name("Anti-venom").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.ANTIDOTE_PLUS2.potion)).primary(12934).ids((Set<Integer>)ImmutableSet.of((Object)12911, (Object)12909, (Object)12907, (Object)12905)).build()),
    SUPER_COMBAT_POTION(Potion.builder().level(90).name("Super combat potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.SUPER_ATTACK.potion, (Object)Potions.SUPER_STRENGTH.potion, (Object)Potions.SUPER_DEFENCE.potion)).primary(269).primaryAlt(219).ids((Set<Integer>)ImmutableSet.of((Object)12701, (Object)12699, (Object)12697, (Object)12695)).build()),
    FORGOTTEN_BREW(Potion.builder().level(91).name("Forgotten brew").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.ANCIENT_BREW.potion)).primary(27616).ids((Set<Integer>)ImmutableSet.of((Object)27638, (Object)27635, (Object)27632, (Object)27629)).build()),
    SUPER_ANTIFIRE_POTION(Potion.builder().level(92).name("Super antifire potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.ANTIFIRE_POTION.potion)).primary(21975).ids((Set<Integer>)ImmutableSet.of((Object)21987, (Object)21984, (Object)21981, (Object)21978)).build()),
    ANTIVENOM_PLUS(Potion.builder().level(94).name("Anti-venom+").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.ANTIVENOM.potion)).primary(269).grimyHerb(219).primarySeed(5304).ids((Set<Integer>)ImmutableSet.of((Object)12919, (Object)12917, (Object)12915, (Object)12913)).build()),
    DIVINE_SUPER_COMBAT(Potion.builder().level(97).name("Divine super combat potion").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.SUPER_COMBAT_POTION.potion)).primary(23804).primaryAlt(23962).ids((Set<Integer>)ImmutableSet.of((Object)23694, (Object)23691, (Object)23688, (Object)23685)).build()),
    EXTENDED_SUPER_ANTIFIRE(Potion.builder().level(98).name("Extended super antifire").complexBase((Set<Potion>)ImmutableSet.of((Object)Potions.ANTIFIRE_POTION.potion)).primary(21975).ids((Set<Integer>)ImmutableSet.of((Object)22218, (Object)22215, (Object)22212, (Object)22209)).build()),
    GUAM_TAR(Potion.builder().level(19).name("Guam tar").primary(249).grimyHerb(199).secondaries((Set<Integer>)ImmutableSet.of((Object)1939)).ids((Set<Integer>)ImmutableSet.of((Object)10142)).build()),
    MARRENTILL_TAR(Potion.builder().level(31).name("Marrentill tar").primary(251).grimyHerb(201).secondaries((Set<Integer>)ImmutableSet.of((Object)1939)).ids((Set<Integer>)ImmutableSet.of((Object)10143)).build()),
    TARROMIN_TAR(Potion.builder().level(39).name("Tarromin tar").primary(253).grimyHerb(203).secondaries((Set<Integer>)ImmutableSet.of((Object)1939)).ids((Set<Integer>)ImmutableSet.of((Object)10144)).build()),
    HARRALANDER_TAR(Potion.builder().level(44).name("Harralander tar").primary(255).grimyHerb(205).secondaries((Set<Integer>)ImmutableSet.of((Object)1939)).ids((Set<Integer>)ImmutableSet.of((Object)10145)).build());

    private static final Map<Integer, List<Potion>> primaryToPotion;
    private static final Map<Integer, List<Potion>> secondariesToPotion;
    private static final Map<Integer, List<Potion>> complexBaseToPotion;
    private static final Map<Integer, List<Potion>> unfinishedToPotion;
    private static final Map<Integer, List<Potion>> seedsToPotion;
    private static final Map<Integer, List<Potion>> grimyToPotion;
    private static final Map<Integer, List<Potion>> allIdsToPotion;
    private static final Set<Integer> allPotionIds;
    public final Potion potion;

    private Potions(Potion potion) {
        this.potion = potion;
    }

    public static Potion getPotion(int potionId) {
        return Arrays.stream(Potions.values()).map(p -> p.potion).filter(potion -> potion.getIds().contains(potionId)).findFirst().orElse(null);
    }

    private static void buildPrimariesAndGrimyMaps() {
        Arrays.stream(Potions.values()).map(p -> p.potion).forEach(p -> {
            int grimyHerbId;
            if (Potions.IMP_REPELLENT.potion.equals(p)) {
                p.getSecondaries().forEach(secondary -> primaryToPotion.put((Integer)secondary, (List<Potion>)ImmutableList.of((Object)p)));
                return;
            }
            int primaryId = p.getPrimary();
            primaryToPotion.computeIfAbsent(primaryId, id -> new ArrayList()).add(p);
            int altPrimaryId = p.getPrimaryAlt();
            if (altPrimaryId > 0) {
                primaryToPotion.computeIfAbsent(altPrimaryId, id -> new ArrayList()).add(p);
            }
            if ((grimyHerbId = p.getGrimyHerb()) > 0) {
                grimyToPotion.computeIfAbsent(grimyHerbId, id -> new ArrayList()).add(p);
            }
        });
    }

    private static void buildSeedsMap() {
        Arrays.stream(Potions.values()).map(p -> p.potion).forEach(p -> {
            int seedId = p.getPrimarySeed();
            if (seedId > 0) {
                seedsToPotion.computeIfAbsent(seedId, id -> new ArrayList()).add(p);
            }
        });
    }

    private static void buildSecondariesMap() {
        Arrays.stream(Potions.values()).map(p -> p.potion).filter(p -> p.getSecondaries() != null && !Potions.IMP_REPELLENT.potion.equals(p)).forEach(p -> p.getSecondaries().forEach(id -> secondariesToPotion.computeIfAbsent((Integer)id, i -> new ArrayList()).add(p)));
        Arrays.stream(Potions.values()).map(p -> p.potion).filter(p -> p.getSecondariesAlt() != null).forEach(p -> p.getSecondariesAlt().forEach(id -> secondariesToPotion.computeIfAbsent((Integer)id, i -> new ArrayList()).add(p)));
    }

    private static void buildComplexBaseMap() {
        Arrays.stream(Potions.values()).map(p -> p.potion).filter(p -> p.getComplexBase() != null).forEach(p -> p.getComplexBase().forEach(base -> base.getIds().forEach(baseId -> complexBaseToPotion.computeIfAbsent((Integer)baseId, i -> new ArrayList()).add(p))));
    }

    private static void buildUnfinishedMap() {
        Arrays.stream(Potions.values()).map(p -> p.potion).filter(p -> p.getUnfinishedPotion() > 0).forEach(p -> unfinishedToPotion.computeIfAbsent(p.getUnfinishedPotion(), id -> new ArrayList()).add(p));
    }

    public static boolean isPrimary(int id) {
        return primaryToPotion.containsKey(id);
    }

    public static boolean isSecondary(int id) {
        return secondariesToPotion.containsKey(id);
    }

    public static boolean isComplexBase(int id) {
        return complexBaseToPotion.containsKey(id);
    }

    public static boolean isSeed(int id) {
        return seedsToPotion.containsKey(id);
    }

    public static boolean isUnfinished(int id) {
        return unfinishedToPotion.containsKey(id);
    }

    public static boolean isPotion(int id) {
        return allPotionIds.contains(id);
    }

    public static boolean isGrimy(int id) {
        return grimyToPotion.containsKey(id);
    }

    public static Set<Integer> allIds() {
        HashSet<Integer> allIds = new HashSet<Integer>();
        allIds.addAll(allIdsToPotion.keySet());
        allIds.addAll(allPotionIds);
        return allIds;
    }

    public static List<Potion> getByPrimary(int id) {
        return primaryToPotion.get(id);
    }

    public static List<Potion> getBySeed(int id) {
        return seedsToPotion.get(id);
    }

    public static List<Potion> getBySecondary(int id) {
        return secondariesToPotion.get(id);
    }

    public static List<Potion> getByComplex(int id) {
        return complexBaseToPotion.get(id);
    }

    public static List<Potion> getByUnfinished(int id) {
        return unfinishedToPotion.get(id);
    }

    public static List<Potion> getByGrimy(int id) {
        return grimyToPotion.get(id);
    }

    static {
        primaryToPotion = new HashMap<Integer, List<Potion>>();
        secondariesToPotion = new HashMap<Integer, List<Potion>>();
        complexBaseToPotion = new HashMap<Integer, List<Potion>>();
        unfinishedToPotion = new HashMap<Integer, List<Potion>>();
        seedsToPotion = new HashMap<Integer, List<Potion>>();
        grimyToPotion = new HashMap<Integer, List<Potion>>();
        allIdsToPotion = new HashMap<Integer, List<Potion>>();
        allPotionIds = new HashSet<Integer>();
        Potions.buildPrimariesAndGrimyMaps();
        Potions.buildSecondariesMap();
        Potions.buildComplexBaseMap();
        Potions.buildUnfinishedMap();
        Potions.buildSeedsMap();
        allIdsToPotion.putAll(primaryToPotion);
        allIdsToPotion.putAll(grimyToPotion);
        allIdsToPotion.putAll(secondariesToPotion);
        allIdsToPotion.putAll(complexBaseToPotion);
        allIdsToPotion.putAll(unfinishedToPotion);
        allIdsToPotion.putAll(seedsToPotion);
        allPotionIds.addAll(Arrays.stream(Potions.values()).map(p -> p.potion.getIds()).flatMap(Collection::stream).collect(Collectors.toSet()));
    }
}

