/*
 * Decompiled with CFR 0.152.
 */
package com.herblorerecipes.model;

import java.util.Set;
import java.util.stream.Collectors;

public class Potion {
    private int level;
    private String name;
    private int basicBase;
    private Set<Potion> complexBase;
    private int unfinishedPotion;
    private int primary;
    private int primaryAlt;
    private int primarySeed;
    private int grimyHerb;
    private Set<Integer> secondaries;
    private Set<Integer> secondariesAlt;
    private Set<Integer> ids;

    public boolean hasComplexBase() {
        return this.complexBase != null;
    }

    public String complexBaseNames() {
        return this.complexBase.stream().map(Potion::getName).collect(Collectors.joining(", "));
    }

    Potion(int level, String name, int basicBase, Set<Potion> complexBase, int unfinishedPotion, int primary, int primaryAlt, int primarySeed, int grimyHerb, Set<Integer> secondaries, Set<Integer> secondariesAlt, Set<Integer> ids) {
        this.level = level;
        this.name = name;
        this.basicBase = basicBase;
        this.complexBase = complexBase;
        this.unfinishedPotion = unfinishedPotion;
        this.primary = primary;
        this.primaryAlt = primaryAlt;
        this.primarySeed = primarySeed;
        this.grimyHerb = grimyHerb;
        this.secondaries = secondaries;
        this.secondariesAlt = secondariesAlt;
        this.ids = ids;
    }

    public static PotionBuilder builder() {
        return new PotionBuilder();
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public int getBasicBase() {
        return this.basicBase;
    }

    public Set<Potion> getComplexBase() {
        return this.complexBase;
    }

    public int getUnfinishedPotion() {
        return this.unfinishedPotion;
    }

    public int getPrimary() {
        return this.primary;
    }

    public int getPrimaryAlt() {
        return this.primaryAlt;
    }

    public int getPrimarySeed() {
        return this.primarySeed;
    }

    public int getGrimyHerb() {
        return this.grimyHerb;
    }

    public Set<Integer> getSecondaries() {
        return this.secondaries;
    }

    public Set<Integer> getSecondariesAlt() {
        return this.secondariesAlt;
    }

    public Set<Integer> getIds() {
        return this.ids;
    }

    public String toString() {
        return "Potion(level=" + this.getLevel() + ", name=" + this.getName() + ", basicBase=" + this.getBasicBase() + ", complexBase=" + this.getComplexBase() + ", unfinishedPotion=" + this.getUnfinishedPotion() + ", primary=" + this.getPrimary() + ", primaryAlt=" + this.getPrimaryAlt() + ", primarySeed=" + this.getPrimarySeed() + ", grimyHerb=" + this.getGrimyHerb() + ", secondaries=" + this.getSecondaries() + ", secondariesAlt=" + this.getSecondariesAlt() + ", ids=" + this.getIds() + ")";
    }

    public static class PotionBuilder {
        private int level;
        private String name;
        private int basicBase;
        private Set<Potion> complexBase;
        private int unfinishedPotion;
        private int primary;
        private int primaryAlt;
        private int primarySeed;
        private int grimyHerb;
        private Set<Integer> secondaries;
        private Set<Integer> secondariesAlt;
        private Set<Integer> ids;

        PotionBuilder() {
        }

        public PotionBuilder level(int level) {
            this.level = level;
            return this;
        }

        public PotionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PotionBuilder basicBase(int basicBase) {
            this.basicBase = basicBase;
            return this;
        }

        public PotionBuilder complexBase(Set<Potion> complexBase) {
            this.complexBase = complexBase;
            return this;
        }

        public PotionBuilder unfinishedPotion(int unfinishedPotion) {
            this.unfinishedPotion = unfinishedPotion;
            return this;
        }

        public PotionBuilder primary(int primary) {
            this.primary = primary;
            return this;
        }

        public PotionBuilder primaryAlt(int primaryAlt) {
            this.primaryAlt = primaryAlt;
            return this;
        }

        public PotionBuilder primarySeed(int primarySeed) {
            this.primarySeed = primarySeed;
            return this;
        }

        public PotionBuilder grimyHerb(int grimyHerb) {
            this.grimyHerb = grimyHerb;
            return this;
        }

        public PotionBuilder secondaries(Set<Integer> secondaries) {
            this.secondaries = secondaries;
            return this;
        }

        public PotionBuilder secondariesAlt(Set<Integer> secondariesAlt) {
            this.secondariesAlt = secondariesAlt;
            return this;
        }

        public PotionBuilder ids(Set<Integer> ids) {
            this.ids = ids;
            return this;
        }

        public Potion build() {
            return new Potion(this.level, this.name, this.basicBase, this.complexBase, this.unfinishedPotion, this.primary, this.primaryAlt, this.primarySeed, this.grimyHerb, this.secondaries, this.secondariesAlt, this.ids);
        }

        public String toString() {
            return "Potion.PotionBuilder(level=" + this.level + ", name=" + this.name + ", basicBase=" + this.basicBase + ", complexBase=" + this.complexBase + ", unfinishedPotion=" + this.unfinishedPotion + ", primary=" + this.primary + ", primaryAlt=" + this.primaryAlt + ", primarySeed=" + this.primarySeed + ", grimyHerb=" + this.grimyHerb + ", secondaries=" + this.secondaries + ", secondariesAlt=" + this.secondariesAlt + ", ids=" + this.ids + ")";
        }
    }
}

