/*
 * Decompiled with CFR 0.152.
 */
package com.herblorerecipes.cache;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.herblorerecipes.HerbloreRecipesConfig;
import com.herblorerecipes.model.Potion;
import com.herblorerecipes.model.Potions;
import com.herblorerecipes.model.TooltipBox;
import com.herblorerecipes.model.TooltipCategory;
import com.herblorerecipes.model.TooltipCategoryContent;
import com.herblorerecipes.model.TooltipStringBuilder;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TooltipCache {
    private static final Logger log = LoggerFactory.getLogger(TooltipCache.class);
    private static final Color GREY = new Color(238, 238, 238);
    private static final Color LIME = new Color(0, 255, 0);
    private static final Color AQUA = new Color(0, 255, 255);
    private static final Color GOLD = new Color(255, 215, 0);
    private static final Color PINK = new Color(236, 128, 255);
    private static final Color PURPLE = new Color(181, 153, 255);
    private static final Color ORANGE = new Color(255, 140, 103);
    private static final Color TURQUOISE = new Color(112, 248, 208);
    private static final String TOOLTIP_PRIMARY_TEXT = TooltipCache.colorWrap("Primary", LIME) + TooltipCache.colorWrap(" for:", GREY);
    private static final String TOOLTIP_SECONDARY_TEXT = TooltipCache.colorWrap("Secondary", AQUA) + TooltipCache.colorWrap(" for:", GREY);
    private static final String TOOLTIP_UNF_TEXT = TooltipCache.colorWrap("Unfinished", GOLD) + TooltipCache.colorWrap(" for:", GREY);
    private static final String TOOLTIP_POTION_TEXT = TooltipCache.colorWrap("Requirements", PINK) + TooltipCache.colorWrap(" for %s:", GREY);
    private static final String TOOLTIP_BASE_TEXT = TooltipCache.colorWrap("Base", PURPLE) + TooltipCache.colorWrap(" for:", GREY);
    private static final String TOOLTIP_SEED_TEXT = TooltipCache.colorWrap("Seed", ORANGE) + TooltipCache.colorWrap(" for:", GREY);
    private static final String TOOLTIP_GRIMY_TEXT = TooltipCache.colorWrap("Clean", TURQUOISE) + TooltipCache.colorWrap(" for:", GREY);
    private final ItemManager itemManager;
    private final ClientThread clientThread;
    private final HerbloreRecipesConfig config;
    private Map<Integer, Tooltip> tooltipCache;

    @Inject
    public TooltipCache(ItemManager itemManager, ClientThread clientThread, HerbloreRecipesConfig config) {
        this.itemManager = itemManager;
        this.clientThread = clientThread;
        this.config = config;
    }

    public void preloadOnClientThread() {
        this.clientThread.invoke(this::preLoadCache);
    }

    private void preLoadCache() {
        this.tooltipCache = new HashMap<Integer, Tooltip>();
        Set<Integer> allIds = Potions.allIds();
        Stopwatch timer = Stopwatch.createStarted();
        allIds.forEach(id -> {
            List<Potion> ps;
            TooltipBox tooltip = new TooltipBox();
            if (Potions.isPotion(id) && this.config.showTooltipOnPotions()) {
                Potion p = Potions.getPotion(id);
                tooltip.getCategories().add(this.tooltipCategory((List<Potion>)ImmutableList.of((Object)p), String.format(TOOLTIP_POTION_TEXT, TooltipCache.colorWrap(p.getName(), AQUA))));
            }
            if (Potions.isPrimary(id) && this.config.showTooltipOnPrimaries()) {
                ps = Potions.getByPrimary(id);
                tooltip.getCategories().add(this.tooltipCategory(ps, TOOLTIP_PRIMARY_TEXT));
            }
            if (Potions.isSecondary(id) && this.config.showTooltipOnSecondaries()) {
                ps = Potions.getBySecondary(id);
                tooltip.getCategories().add(this.tooltipCategory(ps, TOOLTIP_SECONDARY_TEXT));
            }
            if (Potions.isComplexBase(id) && this.config.showTooltipOnComplex()) {
                ps = Potions.getByComplex(id);
                tooltip.getCategories().add(this.tooltipCategory(ps, TOOLTIP_BASE_TEXT));
            }
            if (Potions.isSeed(id)) {
                ps = Potions.getBySeed(id);
                tooltip.getCategories().add(this.tooltipCategory(ps, TOOLTIP_SEED_TEXT));
            }
            if (Potions.isUnfinished(id)) {
                ps = Potions.getByUnfinished(id);
                tooltip.getCategories().add(this.tooltipCategory(ps, TOOLTIP_UNF_TEXT));
            }
            if (Potions.isGrimy(id)) {
                ps = Potions.getByGrimy(id);
                tooltip.getCategories().add(this.tooltipCategory(ps, TOOLTIP_GRIMY_TEXT));
            }
            if (!tooltip.isEmpty()) {
                this.tooltipCache.put((Integer)id, this.buildTooltip(tooltip));
            }
        });
        long nanos = timer.stop().elapsed().toNanos();
        log.info("Tooltip cache was loaded in {}ms.", (Object)((double)nanos / 1000000.0));
    }

    public boolean contains(int id) {
        return this.tooltipCache.containsKey(id);
    }

    public Tooltip get(int id) {
        return this.tooltipCache.get(id);
    }

    private static String colorWrap(String text, Color color) {
        return ColorUtil.wrapWithColorTag((String)text, (Color)color);
    }

    private String itemName(int itemId) {
        return this.itemManager.getItemComposition(itemId).getName();
    }

    private String itemNames(Collection<Integer> items) {
        return items.stream().map(this::itemName).collect(Collectors.joining(", "));
    }

    private TooltipCategory tooltipCategory(List<Potion> potions, String title) {
        TooltipCategory category = new TooltipCategory();
        category.setTitle(title);
        potions.forEach(p -> {
            TooltipCategoryContent content = new TooltipCategoryContent();
            content.setPotion(p.getName());
            content.setLevel(String.valueOf(p.getLevel()));
            if (p.getPrimary() > 0) {
                content.setPrimary(this.itemName(p.getPrimary()));
            }
            if (p.hasComplexBase()) {
                content.setBase(p.complexBaseNames());
            } else {
                content.setBase(this.itemName(p.getBasicBase()));
            }
            if (p.getSecondaries() != null) {
                content.setSecondary(this.itemNames(p.getSecondaries()));
                if (p.getIds().contains(11262) && !this.config.showImpRepellentIngs()) {
                    content.setSecondary("Various flowers...");
                }
            }
            category.getContent().add(content);
        });
        return category;
    }

    private Tooltip buildTooltip(TooltipBox tooltip) {
        TooltipStringBuilder builder = new TooltipStringBuilder();
        tooltip.getCategories().forEach(category -> {
            builder.appendln(category.getTitle());
            category.getContent().forEach(content -> {
                if (this.config.showHerbloreLvlInTooltip()) {
                    builder.append(String.format("lvl %s: ", content.getLevel()));
                }
                builder.append(content.getPotion());
                if (this.config.showPrimariesInTooltip() || this.config.showSecondariesInTooltip()) {
                    String primary = "";
                    if (this.config.showPrimariesInTooltip()) {
                        primary = content.getPrimary();
                    }
                    String secondary = "";
                    if (this.config.showSecondariesInTooltip()) {
                        secondary = content.getSecondary();
                    }
                    Object combined = "";
                    if (primary.isEmpty() && !secondary.isEmpty()) {
                        combined = "2nd: " + secondary;
                    }
                    if (secondary.isEmpty() && !primary.isEmpty()) {
                        combined = "1st: " + primary;
                    }
                    if (!primary.isEmpty() && !secondary.isEmpty()) {
                        combined = "1st: " + primary + " - 2nd: " + secondary;
                    }
                    String ingredients = "%s";
                    if (!primary.isEmpty() || !secondary.isEmpty()) {
                        ingredients = " (%s)";
                    }
                    builder.append(String.format(ingredients, combined));
                }
                builder.appendln("");
            });
        });
        return new Tooltip(builder.toString());
    }

    private void invalidate() {
        this.tooltipCache.clear();
    }

    public void reset() {
        this.invalidate();
        this.preloadOnClientThread();
    }
}

