/*
 * Decompiled with CFR 0.152.
 */
package com.herblorerecipes;

import com.google.inject.Provides;
import com.herblorerecipes.HerbloreRecipesConfig;
import com.herblorerecipes.HerbloreRecipesOverlay;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;

@PluginDescriptor(name="Herblore Recipes", description="Hover over a herblore ingredient or potion in your inventory or bank to see which potions can be made with it or that potion's recipe", tags={"recipes", "herblore", "herb"})
public class HerbloreRecipesPlugin
extends Plugin {
    @Inject
    private Client client;
    @Inject
    private HerbloreRecipesConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private HerbloreRecipesOverlay overlay;

    protected void startUp() throws Exception {
        this.keyManager.registerKeyListener((KeyListener)this.overlay);
        this.overlayManager.add((Overlay)this.overlay);
        this.overlay.tooltipCache.preloadOnClientThread();
    }

    protected void shutDown() throws Exception {
        this.keyManager.unregisterKeyListener((KeyListener)this.overlay);
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
    }

    @Provides
    HerbloreRecipesConfig provideConfig(ConfigManager configManager) {
        return (HerbloreRecipesConfig)configManager.getConfig(HerbloreRecipesConfig.class);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("herblorerecipes".equals(event.getGroup()) && (event.getKey().equals("showPrimaryIngredientsInTooltip") || event.getKey().equals("showSecondaryIngredientsInTooltip") || event.getKey().equals("showHerbloreLvlInTooltip") || event.getKey().equals("showPotionRecipes") || event.getKey().equals("showTooltipOnPrimaries") || event.getKey().equals("showTooltipOnSecondaries") || event.getKey().equals("showTooltipOnComplex") || event.getKey().equals("showImpRepellentIngs"))) {
            this.overlay.tooltipCache.reset();
        }
    }
}

