/*
 * Decompiled with CFR 0.152.
 */
package com.herblorerecipes;

import com.herblorerecipes.HerbloreRecipesConfig;
import com.herblorerecipes.cache.TooltipCache;
import com.herblorerecipes.model.Potions;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.Keybind;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import org.apache.commons.lang3.StringUtils;

public class HerbloreRecipesOverlay
extends Overlay
implements KeyListener {
    private static final int INVENTORY_ITEM_WIDGETID = WidgetInfo.INVENTORY.getPackedId();
    private static final int BANK_ITEM_WIDGETID = WidgetInfo.BANK_ITEM_CONTAINER.getPackedId();
    private static final int BANKED_INVENTORY_ITEM_WIDGETID = WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER.getPackedId();
    private static final int SEED_VAULT_INVENTORY_WIDGETID = WidgetInfo.SEED_VAULT_INVENTORY_ITEMS_CONTAINER.getPackedId();
    private static final int SEED_VAULT_WIDGETID = WidgetInfo.SEED_VAULT_ITEM_CONTAINER.getPackedId();
    private static final int GROUP_STORAGE_ITEM_WIDGETID = WidgetInfo.GROUP_STORAGE_ITEM_CONTAINER.getPackedId();
    public final TooltipCache tooltipCache;
    private final Client client;
    private final TooltipManager tooltipManager;
    private final HerbloreRecipesConfig config;
    private final ItemManager itemManager;
    private boolean boundKeyPressed;

    @Inject
    HerbloreRecipesOverlay(Client client, TooltipManager tooltipManager, HerbloreRecipesConfig config, TooltipCache tooltipCache, ItemManager itemManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.client = client;
        this.tooltipManager = tooltipManager;
        this.config = config;
        this.tooltipCache = tooltipCache;
        this.itemManager = itemManager;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Dimension render(Graphics2D graphics) {
        MenuEntry[] menuEntries;
        int last;
        if (this.client.isMenuOpen()) {
            return null;
        }
        if (!(this.config.showTooltipOnPrimaries() || this.config.showTooltipOnSecondaries() || this.config.showTooltipOnPotions() || this.config.showTooltipOnUnfinished() || this.config.showTooltipOnSeeds() || this.config.showTooltipOnGrimy() || this.config.showTooltipOnComplex())) {
            return null;
        }
        if (this.config.useKeybind()) {
            if (this.config.modifierKey().getKeyCode() == Keybind.NOT_SET.getKeyCode() && this.config.modifierKey().getModifiers() == 0) {
                return null;
            }
            if (!this.boundKeyPressed) {
                return null;
            }
        }
        if ((last = (menuEntries = this.client.getMenuEntries()).length - 1) < 0) {
            return null;
        }
        MenuEntry menuEntry = menuEntries[last];
        if (StringUtils.isEmpty((CharSequence)menuEntry.getTarget()) || menuEntry.getOption().contains("View") || menuEntry.getParam0() < 0) {
            return null;
        }
        MenuAction action = menuEntry.getType();
        int widgetId = menuEntry.getParam1();
        int groupId = WidgetInfo.TO_GROUP((int)widgetId);
        switch (action) {
            case WIDGET_USE_ON_ITEM: 
            case WIDGET_TARGET: 
            case CC_OP: 
            case ITEM_USE: 
            case ITEM_FIRST_OPTION: 
            case ITEM_SECOND_OPTION: 
            case ITEM_THIRD_OPTION: 
            case ITEM_FOURTH_OPTION: 
            case CC_OP_LOW_PRIORITY: 
            case ITEM_FIFTH_OPTION: {
                switch (groupId) {
                    case 15: 
                    case 630: 
                    case 631: {
                        if (!this.config.showTooltipInSeedVault()) {
                            return null;
                        }
                    }
                    case 724: {
                        if (!this.config.showTooltipInGroupStorage()) {
                            return null;
                        }
                    }
                    case 149: {
                        if (!this.config.showTooltipInInv()) {
                            return null;
                        }
                    }
                    case 12: {
                        if (!this.config.showTooltipOnPlaceholder() && action == MenuAction.CC_OP_LOW_PRIORITY) {
                            return null;
                        }
                        if (!this.config.showTooltipInBank()) {
                            return null;
                        }
                        ItemContainer container = this.getContainer(widgetId);
                        if (container == null) {
                            return null;
                        }
                        Item item = container.getItem(menuEntry.getParam0());
                        if (item == null) {
                            return null;
                        }
                        int itemId = this.itemManager.canonicalize(item.getId());
                        if (Potions.isSeed(itemId) && !this.config.showTooltipOnSeeds()) {
                            return null;
                        }
                        if (Potions.isUnfinished(itemId) && !this.config.showTooltipOnUnfinished()) {
                            return null;
                        }
                        if (Potions.isGrimy(itemId) && !this.config.showTooltipOnGrimy()) {
                            return null;
                        }
                        if (!this.tooltipCache.contains(itemId)) return null;
                        this.tooltipManager.add(this.tooltipCache.get(itemId));
                    }
                }
                return null;
            }
        }
        return null;
    }

    private ItemContainer getContainer(int widgetId) {
        if (widgetId == INVENTORY_ITEM_WIDGETID || widgetId == BANKED_INVENTORY_ITEM_WIDGETID || widgetId == SEED_VAULT_INVENTORY_WIDGETID) {
            return this.client.getItemContainer(InventoryID.INVENTORY);
        }
        if (widgetId == BANK_ITEM_WIDGETID) {
            return this.client.getItemContainer(InventoryID.BANK);
        }
        if (widgetId == SEED_VAULT_WIDGETID) {
            return this.client.getItemContainer(InventoryID.SEED_VAULT);
        }
        if (widgetId == GROUP_STORAGE_ITEM_WIDGETID) {
            return this.client.getItemContainer(InventoryID.GROUP_STORAGE);
        }
        return null;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if (this.config.useKeybind() && this.config.modifierKey().matches(e)) {
            this.boundKeyPressed = true;
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.config.useKeybind() && this.config.modifierKey().matches(e)) {
            this.boundKeyPressed = false;
        }
    }
}

