/*
 * Decompiled with CFR 0.152.
 */
package bankequipmentstatfilter;

import bankequipmentstatfilter.BankEquipmentStatFilterConfig;
import bankequipmentstatfilter.BankEquipmentStatFilterPanel;
import bankequipmentstatfilter.EquipmentStat;
import bankequipmentstatfilter.ItemWithStat;
import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.http.api.item.ItemStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bank Equipment Stat Filter", description="Allows to filter/sort for equipment slot/stat", tags={"bank", "stat", "equipment", "filter"})
public class BankEquipmentStatFilterPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankEquipmentStatFilterPlugin.class);
    @Inject
    private Client client;
    @Inject
    private BankEquipmentStatFilterConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ClientThread clientThread;
    private BankEquipmentStatFilterPanel panel;
    private NavigationButton navButton;
    private ItemWithStat[] items;

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() == this.client.getItemContainer(InventoryID.BANK)) {
            Item[] bankItems = event.getItemContainer().getItems();
            this.items = (ItemWithStat[])Arrays.stream(bankItems).map(item -> {
                ItemStats stats = this.itemManager.getItemStats(item.getId(), false);
                ItemComposition composition = this.itemManager.getItemComposition(item.getId());
                if (stats == null || !stats.isEquipable()) {
                    return null;
                }
                return new ItemWithStat(item.getId(), stats, composition.getName());
            }).filter(Objects::nonNull).toArray(ItemWithStat[]::new);
        }
    }

    protected void startUp() {
        this.panel = (BankEquipmentStatFilterPanel)((Object)this.injector.getInstance(BankEquipmentStatFilterPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(BankEquipmentStatFilterPlugin.class, (String)"pluginIcon.png");
        this.navButton = NavigationButton.builder().tooltip("Bank Equipment Stat Filtering").icon(icon).panel((PluginPanel)this.panel).priority(6).build();
        this.clientToolbar.addNavigation(this.navButton);
    }

    protected void shutDown() {
        this.clientToolbar.removeNavigation(this.navButton);
    }

    public void bankFilter(EquipmentInventorySlot slot, EquipmentStat statType) {
        if (this.items == null) {
            this.panel.displayMessage("You need to open your bank once so the plugin can sync with it");
            return;
        }
        ItemWithStat[] sortedItems = (ItemWithStat[])Arrays.stream(this.items).filter(item -> this.getItemStat(item.getStats(), statType) > 0 && item.getStats().getEquipment().getSlot() == slot.getSlotIdx()).sorted(Comparator.comparing(item -> this.getItemStat(((ItemWithStat)item).getStats(), statType)).reversed()).toArray(ItemWithStat[]::new);
        this.panel.displayItems(sortedItems, statType);
    }

    public int getItemStat(ItemStats stats, EquipmentStat stat) {
        if (stats == null || !stats.isEquipable()) {
            return -1;
        }
        switch (stat) {
            case STAB_ATTACK: {
                return stats.getEquipment().getAstab();
            }
            case SLASH_ATTACK: {
                return stats.getEquipment().getAslash();
            }
            case CRUSH_ATTACK: {
                return stats.getEquipment().getAcrush();
            }
            case MAGIC_ATTACK: {
                return stats.getEquipment().getAmagic();
            }
            case RANGE_ATTACK: {
                return stats.getEquipment().getArange();
            }
            case STAB_DEFENCE: {
                return stats.getEquipment().getDstab();
            }
            case SLASH_DEFENCE: {
                return stats.getEquipment().getDslash();
            }
            case CRUSH_DEFENCE: {
                return stats.getEquipment().getDcrush();
            }
            case MAGIC_DEFENCE: {
                return stats.getEquipment().getDmagic();
            }
            case RANGE_DEFENCE: {
                return stats.getEquipment().getDrange();
            }
            case MELEE_STRENGTH: {
                return stats.getEquipment().getStr();
            }
            case RANGE_STRENGTH: {
                return stats.getEquipment().getRstr();
            }
            case MAGIC_DAMAGE: {
                return stats.getEquipment().getMdmg();
            }
            case PRAYER: {
                return stats.getEquipment().getPrayer();
            }
        }
        return -1;
    }

    @Provides
    BankEquipmentStatFilterConfig provideConfig(ConfigManager configManager) {
        return (BankEquipmentStatFilterConfig)configManager.getConfig(BankEquipmentStatFilterConfig.class);
    }
}

