/*
 * Decompiled with CFR 0.152.
 */
package bankequipmentstatfilter;

import bankequipmentstatfilter.BankEquipmentStatFilterPlugin;
import bankequipmentstatfilter.EquipmentStat;
import bankequipmentstatfilter.ItemWithStat;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.client.game.ItemManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.AsyncBufferedImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BankEquipmentStatFilterPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(BankEquipmentStatFilterPanel.class);
    private static final int COLUMN_SIZE = 5;
    private static final int ICON_WIDTH = 36;
    private static final int ICON_HEIGHT = 32;
    @Inject
    ItemManager itemManager;
    @Inject
    BankEquipmentStatFilterPlugin plugin;
    JPanel itemsPanel;
    JComboBox<EquipmentStat> statDropDown;
    JComboBox<EquipmentInventorySlot> slotDropDown;

    BankEquipmentStatFilterPanel() {
        this.setLayout(new BorderLayout());
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        JPanel selectionPanel = new JPanel();
        selectionPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        selectionPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
        selectionPanel.setLayout(new GridLayout(3, 2));
        JLabel statLabel = new JLabel();
        statLabel.setText("Stat for equipment: ");
        selectionPanel.add(statLabel);
        this.statDropDown = new JComboBox<EquipmentStat>(EquipmentStat.values());
        this.statDropDown.setFocusable(false);
        selectionPanel.add(this.statDropDown);
        JLabel slotLabel = new JLabel();
        slotLabel.setText("Slot for equipment: ");
        selectionPanel.add(slotLabel);
        this.slotDropDown = new JComboBox<EquipmentInventorySlot>(EquipmentInventorySlot.values());
        this.slotDropDown.setFocusable(false);
        selectionPanel.add(this.slotDropDown);
        selectionPanel.add(new JLabel());
        JButton filterButton = new JButton();
        filterButton.addActionListener(actionEvent -> {
            this.plugin.bankFilter((EquipmentInventorySlot)this.slotDropDown.getSelectedItem(), (EquipmentStat)((Object)((Object)this.statDropDown.getSelectedItem())));
            this.repaint();
        });
        filterButton.setText("View Items");
        filterButton.setFocusable(false);
        selectionPanel.add(filterButton);
        this.add(selectionPanel, "North");
        this.itemsPanel = new JPanel();
        this.itemsPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.itemsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.add(this.itemsPanel, "South");
    }

    public void displayItems(ItemWithStat[] items, EquipmentStat statType) {
        this.itemsPanel.removeAll();
        int rowCorrection = items.length % 5 > 0 ? 1 : 0;
        int rowSize = items.length / 5 + rowCorrection;
        this.itemsPanel.setLayout(new GridLayout(rowSize, 5, 1, 1));
        if (items.length > 0) {
            for (ItemWithStat item : items) {
                JPanel itemPanel = new JPanel();
                JLabel itemLabel = new JLabel();
                itemLabel.setHorizontalAlignment(0);
                itemLabel.setVerticalAlignment(0);
                AsyncBufferedImage icon = this.itemManager.getImage(item.getId());
                icon.addTo(itemLabel);
                itemLabel.setSize(icon.getWidth(), icon.getHeight());
                itemLabel.setMaximumSize(new Dimension(36, 32));
                itemLabel.setToolTipText(String.format("%s (+%s)", item.getName(), this.plugin.getItemStat(item.getStats(), statType)));
                itemPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
                itemPanel.add(itemLabel);
                this.itemsPanel.add(itemPanel);
            }
            this.padItemsPanel(rowSize * 5 % items.length);
        } else {
            this.displayMessage("No matching items found");
        }
        this.repaint();
        this.revalidate();
    }

    public void displayMessage(String message) {
        this.itemsPanel.removeAll();
        this.itemsPanel.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea();
        textArea.setText(message);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        textArea.setFocusable(false);
        textArea.setEditable(false);
        textArea.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.itemsPanel.add(textArea);
        this.repaint();
        this.revalidate();
    }

    private void padItemsPanel(int padAmt) {
        for (int i = 0; i < padAmt; ++i) {
            JPanel panel = new JPanel();
            panel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
            this.itemsPanel.add(panel);
        }
    }
}

