/*
 * Decompiled with CFR 0.152.
 */
package com.geel.customitemhovers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.client.game.ItemManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemNameMap {
    private static final Logger log = LoggerFactory.getLogger(ItemNameMap.class);
    private static final Map<String, ArrayList<Integer>> itemNameToIDs = new HashMap<String, ArrayList<Integer>>();

    public static void PrepareMap(Client client, ItemManager itemManager) {
        if (itemNameToIDs.size() > 0) {
            return;
        }
        itemNameToIDs.clear();
        HashSet<Integer> processedIDs = new HashSet<Integer>();
        for (int i = 0; i < client.getItemCount(); ++i) {
            int canonicalID = itemManager.canonicalize(i);
            if (processedIDs.contains(canonicalID)) continue;
            processedIDs.add(canonicalID);
            ItemComposition comp = itemManager.getItemComposition(canonicalID);
            String itemName = comp.getName();
            if (itemName.toLowerCase().equals("null")) {
                log.error("Item ID " + canonicalID + " has a null name");
                continue;
            }
            if (!itemNameToIDs.containsKey(itemName)) {
                itemNameToIDs.put(itemName, new ArrayList(1));
            }
            itemNameToIDs.get(itemName).add(canonicalID);
        }
    }

    public static int[] GetItemIDs(String itemName) {
        ArrayList itemIDs = itemNameToIDs.getOrDefault(itemName, new ArrayList(0));
        int[] ret = new int[itemIDs.size()];
        for (int i = 0; i < itemIDs.size(); ++i) {
            ret[i] = (Integer)itemIDs.get(i);
        }
        return ret;
    }

    public static ArrayList<Integer> GetItemIDsRegex(String itemNameRegex) {
        ArrayList<Integer> ret = new ArrayList<Integer>(1);
        Pattern finder = Pattern.compile(itemNameRegex);
        if (finder == null) {
            return ret;
        }
        for (String entry : itemNameToIDs.keySet()) {
            if (!finder.matcher(entry).matches()) continue;
            for (int itemID : itemNameToIDs.get(entry)) {
                if (ret.contains(itemID)) continue;
                ret.add(itemID);
            }
        }
        return ret;
    }
}

