/*
 * Decompiled with CFR 0.152.
 */
package com.geel.customitemhovers;

import com.geel.customitemhovers.HoverDef;
import com.geel.customitemhovers.HoverFile;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoverFileParser {
    private static final Logger log = LoggerFactory.getLogger(HoverFileParser.class);
    private static StringBuilder _hoverBuilder = new StringBuilder();

    public static ArrayList<HoverFile> readHoverFiles(Path dirPath) {
        ArrayList<HoverFile> ret = new ArrayList<HoverFile>();
        if (!Files.isDirectory(dirPath, new LinkOption[0]) || !Files.isReadable(dirPath)) {
            return ret;
        }
        try {
            Stream<Path> fileStream = Files.list(dirPath);
            Iterator it = fileStream.iterator();
            while (it.hasNext()) {
                HoverFile file;
                Path p = (Path)it.next();
                if (!Files.isRegularFile(p, new LinkOption[0]) || !Files.isReadable(p) || !p.toString().endsWith(".json") || (file = HoverFileParser.parseHoverFile(p)) == null || file.IsHoverMap == null || !file.IsHoverMap.equals("absolutely")) continue;
                HoverFileParser.postProcessHoverFile(file);
                ret.add(file);
            }
        }
        catch (IOException e) {
            log.error(e.toString());
            return ret;
        }
        return ret;
    }

    private static HoverFile parseHoverFile(Path hoverFile) {
        try {
            byte[] fileBytes = Files.readAllBytes(hoverFile);
            String fileString = new String(fileBytes);
            Gson gson = new Gson();
            return (HoverFile)gson.fromJson(fileString, HoverFile.class);
        }
        catch (Exception e) {
            log.error(e.toString());
            return null;
        }
    }

    private static void postProcessHoverFile(HoverFile f) {
        for (HoverDef d : f.Hovers) {
            HoverFileParser.parseHoverDefHovers(d);
        }
    }

    private static void parseHoverDefHovers(HoverDef d) {
        d.ParsedHoverTexts = new String[d.HoverTexts.length];
        int i = 0;
        for (String[] hovers : d.HoverTexts) {
            _hoverBuilder.setLength(0);
            boolean firstLine = true;
            for (String hoverLine : hovers) {
                if (!firstLine) {
                    _hoverBuilder.append("</br>");
                }
                _hoverBuilder.append(hoverLine);
                firstLine = false;
            }
            d.ParsedHoverTexts[i++] = _hoverBuilder.toString();
        }
    }
}

