/*
 * Decompiled with CFR 0.152.
 */
package com.geel.customitemhovers;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;

public class HoverEvaluator {
    private static final String[] HOVER_FUNCTIONS = new String[]{"qtymult"};
    private static final String[] HOVER_VARIABLES = new String[]{"ID", "QTY", "VALUE", "HIGH_ALCH"};
    private static final Pattern funcFinder = Pattern.compile("<%(qtymult)(\\((\\d+)\\))?%>");
    private static Pattern variableFinder = null;

    private static Pattern getVariableRegex() {
        if (variableFinder != null) {
            return variableFinder;
        }
        StringBuilder variableNames = new StringBuilder();
        for (String s : HOVER_VARIABLES) {
            variableNames.append(s);
            variableNames.append("|");
        }
        variableNames.deleteCharAt(variableNames.length() - 1);
        variableNames.insert(0, "<%(");
        variableNames.append(")%>");
        variableFinder = Pattern.compile(variableNames.toString());
        return variableFinder;
    }

    public static String Evaluate(String text, Item item, ItemComposition comp) {
        String ret = text;
        ret = HoverEvaluator.EvaluateVariables(ret, item, comp);
        ret = HoverEvaluator.EvaluateFunctions(ret, item, comp);
        return ret;
    }

    private static String EvaluateVariables(String text, Item item, ItemComposition comp) {
        String ret = text;
        Matcher varMatcher = HoverEvaluator.getVariableRegex().matcher(text);
        while (varMatcher.find()) {
            MatchResult result = varMatcher.toMatchResult();
            String matchText = result.group();
            String varName = result.group(1);
            String replaceWith = matchText;
            switch (varName) {
                case "ID": {
                    replaceWith = String.valueOf(item.getId());
                    break;
                }
                case "QTY": {
                    replaceWith = String.valueOf(item.getQuantity());
                    break;
                }
                case "VALUE": {
                    replaceWith = String.valueOf(comp.getPrice());
                    break;
                }
                case "HIGH_ALCH": {
                    replaceWith = String.valueOf(comp.getHaPrice());
                    break;
                }
            }
            if (replaceWith == null || replaceWith.equals(matchText)) continue;
            ret = ret.replace(matchText, replaceWith);
        }
        return ret;
    }

    private static String EvaluateFunctions(String text, Item item, ItemComposition comp) {
        String ret = text;
        Matcher funcMatcher = funcFinder.matcher(text);
        while (funcMatcher.find()) {
            MatchResult result = funcMatcher.toMatchResult();
            String matchText = result.group();
            String funcName = result.group(1);
            String args = result.group(3);
            boolean hasArgs = args != null;
            String replaceWith = matchText;
            switch (funcName) {
                case "qtymult": {
                    String qtyText;
                    int qty = item.getQuantity();
                    int mult = 1;
                    if (hasArgs) {
                        mult = Integer.parseInt(args);
                    }
                    replaceWith = qtyText = NumberFormat.getNumberInstance(Locale.getDefault()).format(qty *= mult);
                    break;
                }
            }
            if (replaceWith == null || replaceWith.equals(matchText)) continue;
            ret = ret.replace(matchText, replaceWith);
        }
        return ret;
    }
}

