/*
 * Decompiled with CFR 0.152.
 */
package com.geel.customitemhovers;

import com.geel.customitemhovers.CustomItemHoversConfig;
import com.geel.customitemhovers.CustomItemHoversOverlay;
import com.geel.customitemhovers.HoverDef;
import com.geel.customitemhovers.HoverFile;
import com.geel.customitemhovers.HoverFileParser;
import com.geel.customitemhovers.ItemNameMap;
import com.google.inject.Provides;
import java.awt.Desktop;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Item;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.CommandExecuted;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Custom Item Hovers", description="Enables custom item hovers. Read github page.", tags={"custom", "item", "hovers", "tooltips"}, enabledByDefault=true)
public class CustomItemHoversPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CustomItemHoversPlugin.class);
    private static final String PLUGIN_FOLDER_NAME = "customitemhovers";
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private CustomItemHoversOverlay overlay;
    @Inject
    private CustomItemHoversConfig config;
    public Map<Integer, ArrayList<HoverDef>> hovers = new HashMap<Integer, ArrayList<HoverDef>>();
    WatchService hoverWatcher;
    WatchKey hoverWatchKey;

    @Provides
    CustomItemHoversConfig getConfig(ConfigManager configManager) {
        return (CustomItemHoversConfig)configManager.getConfig(CustomItemHoversConfig.class);
    }

    protected void startUp() throws Exception {
        this.prepareHoverFolder();
        this.clientThread.invokeLater(() -> {
            this.prepareItemNameMap();
            this.prepareHoverMap();
            this.prepareHoverWatcher();
        });
        this.overlayManager.add((Overlay)this.overlay);
    }

    protected void shutDown() throws Exception {
        if (this.hoverWatcher != null) {
            this.hoverWatcher.close();
        }
        this.overlayManager.remove((Overlay)this.overlay);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged ev) {
        if (ev.getGroup().equals(PLUGIN_FOLDER_NAME) && ev.getKey().equals("hoverEnableHotReload")) {
            if (this.config.hoverEnableHotReload()) {
                this.clientThread.invoke(this::prepareHoverWatcher);
            } else {
                this.clientThread.invoke(this::stopHoverWatcher);
            }
        }
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        if (!commandExecuted.getCommand().equals(this.config.openDirChatCommand())) {
            return;
        }
        Path hoverPath = this.getHoverPath();
        if (hoverPath == null) {
            return;
        }
        try {
            Desktop.getDesktop().open(hoverPath.toFile());
        }
        catch (Exception e) {
            log.error("Got exception opening hover folder", (Throwable)e);
        }
    }

    public String[] getItemHovers(Item item) {
        if (this.config.hoverEnableHotReload() && this.hoverWatcherTriggered()) {
            this.prepareHoverMap();
        }
        int itemID = this.itemManager.canonicalize(item.getId());
        ItemComposition comp = this.itemManager.getItemComposition(itemID);
        if (!this.hovers.containsKey(itemID)) {
            return new String[0];
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (HoverDef d : this.hovers.get(itemID)) {
            ret.addAll(Arrays.asList(d.GetTransformedTexts(item, comp)));
        }
        String[] retArr = new String[ret.size()];
        retArr = ret.toArray(retArr);
        return retArr;
    }

    public Path getHoverPath() {
        return Paths.get(RuneLite.RUNELITE_DIR.getAbsolutePath() + "/customitemhovers", new String[0]);
    }

    protected void prepareItemNameMap() {
        ItemNameMap.PrepareMap(this.client, this.itemManager);
    }

    protected void prepareHoverFolder() throws IOException {
        Path rlPath = RuneLite.RUNELITE_DIR.toPath();
        if (!(Files.isDirectory(rlPath, new LinkOption[0]) && Files.isReadable(rlPath) && Files.isWritable(rlPath))) {
            log.error("[CUSTOMITEMHOVERS] Bad .runelite path");
            return;
        }
        Path hoverPath = this.getHoverPath();
        if (Files.notExists(hoverPath, new LinkOption[0])) {
            Files.createDirectory(hoverPath, new FileAttribute[0]);
        }
        if (!Files.isDirectory(rlPath, new LinkOption[0]) || !Files.isReadable(rlPath)) {
            log.error("[CUSTOMITEMHOVERS] Bad hover path");
        }
    }

    protected void prepareHoverMap() {
        this.hovers.clear();
        ArrayList<HoverFile> hoverFiles = HoverFileParser.readHoverFiles(this.getHoverPath());
        for (HoverFile f : hoverFiles) {
            for (HoverDef d : f.Hovers) {
                this.parseHoverDefNames(d);
                for (int itemID : d.ItemIDs) {
                    if (!this.hovers.containsKey(itemID)) {
                        this.hovers.put(itemID, new ArrayList());
                    }
                    ArrayList<HoverDef> curArr = this.hovers.get(itemID);
                    curArr.add(d);
                }
            }
        }
    }

    private boolean hoverWatcherTriggered() {
        if (this.hoverWatchKey == null || !this.hoverWatchKey.isValid()) {
            return false;
        }
        boolean triggered = this.hoverWatchKey.pollEvents().size() > 0;
        this.hoverWatchKey.reset();
        return triggered;
    }

    private void prepareHoverWatcher() {
        if (!this.config.hoverEnableHotReload()) {
            return;
        }
        Path hoverPath = this.getHoverPath();
        if (hoverPath == null) {
            return;
        }
        try {
            this.hoverWatcher = FileSystems.getDefault().newWatchService();
            this.hoverWatchKey = hoverPath.register(this.hoverWatcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopHoverWatcher() {
        if (this.hoverWatcher != null) {
            try {
                this.hoverWatcher.close();
            }
            catch (IOException e) {
                log.error("[CUSTOMITEMHOVERS]: exception closing hover watcher", (Throwable)e);
            }
            this.hoverWatcher = null;
        }
        if (this.hoverWatchKey != null) {
            this.hoverWatchKey.cancel();
            this.hoverWatchKey = null;
        }
    }

    private void parseHoverDefNames(HoverDef d) {
        HashSet<Integer> itemIDs = new HashSet<Integer>();
        if (d.ItemNamesRegex != null) {
            for (String name : d.ItemNamesRegex) {
                itemIDs.addAll(ItemNameMap.GetItemIDsRegex(name));
            }
        }
        if (d.ItemNames != null) {
            for (String name : d.ItemNames) {
                for (int id : ItemNameMap.GetItemIDs(name)) {
                    itemIDs.add(id);
                }
            }
        }
        if (d.ItemIDs != null && d.ItemIDs.length > 0) {
            for (int id : d.ItemIDs) {
                itemIDs.add(id);
            }
        }
        d.ItemIDs = new int[itemIDs.size()];
        boolean bl = false;
        Iterator it = itemIDs.iterator();
        while (it.hasNext()) {
            int id = (Integer)it.next();
            d.ItemIDs[++var3_9] = id;
        }
    }
}

