/*
 * Decompiled with CFR 0.152.
 */
package com.geel.customitemhovers;

import com.geel.customitemhovers.CustomItemHoversConfig;
import com.geel.customitemhovers.CustomItemHoversPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;
import net.runelite.client.util.ColorUtil;

class CustomItemHoversOverlay
extends Overlay {
    private static final int BANK_ITEM_WIDGETID = WidgetInfo.BANK_ITEM_CONTAINER.getPackedId();
    private static final int SEED_VAULT_ITEM_WIDGETID = WidgetInfo.SEED_VAULT_ITEM_CONTAINER.getPackedId();
    private static final Set<Integer> INVENTORY_WIDGET_IDs = new HashSet<Integer>(Arrays.asList(WidgetInfo.INVENTORY.getPackedId(), WidgetInfo.BANK_INVENTORY_ITEMS_CONTAINER.getPackedId(), WidgetInfo.EXPLORERS_RING_ALCH_INVENTORY.getPackedId(), WidgetInfo.SEED_VAULT_INVENTORY_ITEMS_CONTAINER.getPackedId()));
    private static final Set<Integer> VALID_WIDGET_GROUP_IDS = new HashSet<Integer>(Arrays.asList(149, 12, 15, 631, 630));
    private static final Set<MenuAction> VALID_MENU_ACTIONS = new HashSet<MenuAction>(Arrays.asList(MenuAction.CC_OP, MenuAction.ITEM_USE, MenuAction.WIDGET_TARGET, MenuAction.ITEM_FIRST_OPTION, MenuAction.ITEM_SECOND_OPTION, MenuAction.ITEM_THIRD_OPTION, MenuAction.ITEM_FOURTH_OPTION, MenuAction.ITEM_FIFTH_OPTION));
    private final Client client;
    private final CustomItemHoversConfig config;
    private final CustomItemHoversPlugin plugin;
    private final TooltipManager tooltipManager;

    @Inject
    CustomItemHoversOverlay(Client client, CustomItemHoversPlugin plugin, CustomItemHoversConfig config, TooltipManager tooltipManager) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
        this.tooltipManager = tooltipManager;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.client.isMenuOpen()) {
            return null;
        }
        MenuEntry[] menuEntries = this.client.getMenuEntries();
        if (menuEntries.length <= 0) {
            return null;
        }
        MenuEntry lastEntry = menuEntries[menuEntries.length - 1];
        MenuAction action = lastEntry.getType();
        int widgetId = lastEntry.getParam1();
        int groupId = WidgetInfo.TO_GROUP((int)widgetId);
        if (!VALID_MENU_ACTIONS.contains(action)) {
            return null;
        }
        if (!VALID_WIDGET_GROUP_IDS.contains(groupId)) {
            return null;
        }
        ItemContainer container = this.getContainer(widgetId);
        if (container == null) {
            return null;
        }
        int containerItemIndex = lastEntry.getParam0();
        Item item = container.getItem(containerItemIndex);
        if (item == null) {
            return null;
        }
        String[] hoverTexts = this.plugin.getItemHovers(item);
        if (hoverTexts.length == 0) {
            return null;
        }
        for (String s : hoverTexts) {
            this.tooltipManager.add(new Tooltip(ColorUtil.prependColorTag((String)s, (Color)this.config.defaultHoverColor())));
        }
        return null;
    }

    private ItemContainer getContainer(int widgetId) {
        if (INVENTORY_WIDGET_IDs.contains(widgetId)) {
            return this.client.getItemContainer(InventoryID.INVENTORY);
        }
        if (widgetId == BANK_ITEM_WIDGETID) {
            return this.client.getItemContainer(InventoryID.BANK);
        }
        if (widgetId == SEED_VAULT_ITEM_WIDGETID) {
            return this.client.getItemContainer(InventoryID.SEED_VAULT);
        }
        return null;
    }
}

