/*
 * Decompiled with CFR 0.152.
 */
package com.github.i.fuzzybanksearch.matcher.fzf;

import java.util.Arrays;

public class Result {
    private final String text;
    private final int start;
    private final int end;
    private final int score;
    private final int[] positions;
    private final int itemIndex;

    public static Result empty(String text, int itemIndex) {
        return new Result(text, 0, 0, 0, null, itemIndex);
    }

    public static Result noMatch(String text, int itemIndex) {
        return new Result(text, -1, -1, 0, null, itemIndex);
    }

    public Result(String text, int start, int end, int score, int[] positions, int itemIndex) {
        this.text = text;
        this.start = start;
        this.end = end;
        this.score = score;
        this.positions = positions;
        this.itemIndex = itemIndex;
    }

    public String getText() {
        return this.text;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getScore() {
        return this.score;
    }

    public int[] getPositions() {
        return this.positions;
    }

    public boolean isMatch() {
        return this.start != -1 && this.end != -1;
    }

    public int getItemIndex() {
        return this.itemIndex;
    }

    public String toString() {
        return "Result{text='" + this.text + "', start=" + this.start + ", end=" + this.end + ", score=" + this.score + ", positions=" + Arrays.toString(this.positions) + ", itemIndex=" + this.itemIndex + "}";
    }
}

