/*
 * Decompiled with CFR 0.152.
 */
package com.github.i.fuzzybanksearch.matcher.fzf;

import java.text.Normalizer;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Normalizer {
    private static final Pattern diacriticalMarksPattern = Pattern.compile("\\p{Block=CombiningDiacriticalMarks}+");

    public static String normalize(String string) {
        String normalizedString = java.text.Normalizer.normalize(string, Normalizer.Form.NFKD);
        return diacriticalMarksPattern.matcher(normalizedString).replaceAll("");
    }

    public static List<String> normalize(List<String> strings) {
        return strings.parallelStream().map(Normalizer::normalize).collect(Collectors.toList());
    }
}

