/*
 * Decompiled with CFR 0.152.
 */
package com.github.i.fuzzybanksearch.matcher.fzf;

import com.github.i.fuzzybanksearch.matcher.fzf.Normalizer;
import com.github.i.fuzzybanksearch.matcher.fzf.OrderBy;
import com.github.i.fuzzybanksearch.matcher.fzf.Result;
import com.github.i.fuzzybanksearch.matcher.fzf.ResultComparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FuzzyMatcherV1 {
    static final int SCORE_MATCH = 16;
    static final int SCORE_GAP_START = -3;
    static final int SCORE_GAP_EXTENSION = -1;
    static final int BONUS_BOUNDARY = 8;
    static final int BONUS_NON_WORD = 8;
    static final int BONUS_CAMEL_123 = 7;
    static final int BONUS_CONSECUTIVE = 4;
    static final int BONUS_FIRST_CHAR_MULTIPLIER = 2;
    private final List<String> items;
    private final OrderBy orderBy;
    private final boolean normalize;
    private final List<String> normalizedItems;
    private final boolean caseSensitive;

    public FuzzyMatcherV1(List<String> items, OrderBy orderBy, boolean normalize, boolean caseSensitive) {
        this.items = items;
        this.orderBy = orderBy;
        this.normalize = normalize;
        this.normalizedItems = normalize ? Normalizer.normalize(items) : items;
        this.caseSensitive = caseSensitive;
    }

    public List<String> match(String pattern) {
        if (pattern.isEmpty()) {
            return this.items;
        }
        String lowercasePattern = this.caseSensitive ? pattern : pattern.toLowerCase();
        String normalizedPattern = this.normalize ? Normalizer.normalize(lowercasePattern) : lowercasePattern;
        return IntStream.range(0, this.items.size()).parallel().mapToObj(i -> this.match(this.items.get(i), this.normalizedItems.get(i), normalizedPattern, i)).filter(Result::isMatch).sorted(new ResultComparator(this.orderBy)).map(Result::getText).collect(Collectors.toList());
    }

    private Result match(String text, String normalizedText, String pattern, int itemIndex) {
        char queryChar;
        char textChar;
        int textIndex;
        int queryIndex = 0;
        int startIndex = -1;
        int endIndex = -1;
        for (textIndex = 0; textIndex < normalizedText.length(); ++textIndex) {
            textChar = normalizedText.charAt(textIndex);
            queryChar = pattern.charAt(queryIndex);
            CharClass charClass = CharClass.forChar(textChar);
            if (!this.caseSensitive && charClass == CharClass.UPPER) {
                textChar = Character.toLowerCase(textChar);
            }
            if (textChar != queryChar) continue;
            if (startIndex == -1) {
                startIndex = textIndex;
            }
            if (queryIndex == pattern.length() - 1) {
                endIndex = textIndex + 1;
                break;
            }
            ++queryIndex;
        }
        if (startIndex != -1 && endIndex != -1) {
            for (textIndex = endIndex - 1; textIndex > startIndex; --textIndex) {
                textChar = normalizedText.charAt(textIndex);
                if (textChar != (queryChar = pattern.charAt(queryIndex))) continue;
                if (queryIndex == 0) {
                    startIndex = textIndex;
                    break;
                }
                --queryIndex;
            }
            return this.calculateScore(text, normalizedText, pattern, startIndex, endIndex, itemIndex);
        }
        return Result.noMatch(text, itemIndex);
    }

    private Result calculateScore(String text, String normalizedText, String pattern, int startIndex, int endIndex, int itemIndex) {
        int patternIndex = 0;
        int score = 0;
        int consecutive = 0;
        int firstBonus = 0;
        boolean inGap = false;
        int[] pos = new int[pattern.length()];
        CharClass prevClass = startIndex > 0 ? CharClass.forChar(normalizedText.charAt(startIndex - 1)) : CharClass.NON_WORD;
        for (int i = startIndex; i < endIndex; ++i) {
            char c = normalizedText.charAt(i);
            CharClass charClass = CharClass.forChar(c);
            if (!this.caseSensitive && charClass == CharClass.UPPER) {
                c = Character.toLowerCase(c);
            }
            if (c == pattern.charAt(patternIndex)) {
                pos[patternIndex] = i;
                score += 16;
                int bonus = this.bonusFor(prevClass, charClass);
                if (consecutive == 0) {
                    firstBonus += bonus;
                } else {
                    if (bonus == 8) {
                        firstBonus = bonus;
                    }
                    bonus = Math.max(Math.max(bonus, firstBonus), 4);
                }
                score = patternIndex == 0 ? (score += bonus * 2) : (score += bonus);
                inGap = false;
                ++consecutive;
                ++patternIndex;
            } else {
                score = inGap ? --score : (score -= 3);
                inGap = true;
                consecutive = 0;
                firstBonus = 0;
            }
            prevClass = charClass;
        }
        return new Result(text, startIndex, endIndex, score, pos, itemIndex);
    }

    private int bonusFor(CharClass prevClass, CharClass charClass) {
        if (prevClass == CharClass.NON_WORD && charClass != CharClass.NON_WORD) {
            return 8;
        }
        if (prevClass == CharClass.LOWER && charClass == CharClass.UPPER || prevClass != CharClass.NUMBER && charClass == CharClass.NUMBER) {
            return 7;
        }
        if (charClass == CharClass.NON_WORD) {
            return 8;
        }
        return 0;
    }

    private static enum CharClass {
        LOWER,
        UPPER,
        LETTER,
        NUMBER,
        NON_WORD;


        public static CharClass forChar(char c) {
            if (Character.isLowerCase(c)) {
                return LOWER;
            }
            if (Character.isUpperCase(c)) {
                return UPPER;
            }
            if (Character.isDigit(c)) {
                return NUMBER;
            }
            if (Character.isLetter(c)) {
                return LETTER;
            }
            return NON_WORD;
        }
    }
}

