/*
 * Decompiled with CFR 0.152.
 */
package com.github.i.fuzzybanksearch.matcher;

import com.github.i.fuzzybanksearch.matcher.Matcher;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.text.similarity.JaroWinklerDistance;
import org.apache.commons.text.similarity.SimilarityScore;

public class JaroWinklerMatcher
extends Matcher {
    private final SimilarityScore<Double> baseAlgorithm = new JaroWinklerDistance();
    private final Collection<String> dictionary;

    public JaroWinklerMatcher(Collection<String> dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public Set<String> match(String query, int limit) {
        return this.dictionary.stream().map(term -> new MatchResult((String)term, this.score(query, (String)term))).sorted(Comparator.comparingDouble(res -> -res.getScore())).map(MatchResult::getTerm).limit(limit).collect(Collectors.toSet());
    }

    private Double score(String query, String itemName) {
        int prefixLen;
        query = query.toLowerCase().replace('-', ' ');
        itemName = itemName.toLowerCase().replace('-', ' ');
        int maxLen = Math.min(query.length(), itemName.length());
        for (prefixLen = 0; prefixLen < maxLen && query.charAt(prefixLen) == itemName.charAt(prefixLen); ++prefixLen) {
        }
        double prefixScore = (double)prefixLen / (double)query.length() - 0.25;
        double proximityScore = (Double)this.baseAlgorithm.apply((CharSequence)query, (CharSequence)itemName) - 0.25;
        return prefixScore + proximityScore;
    }

    private static class MatchResult {
        private final String term;
        private final double score;

        public MatchResult(String term, double score) {
            this.term = term;
            this.score = score;
        }

        public double getScore() {
            return this.score;
        }

        public String getTerm() {
            return this.term;
        }
    }
}

